/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ExposedDescriptor
implements Descriptor {
    private static final Predicate<PropertyDescriptor> EXPOSED_PROPERTIES = new Predicate<PropertyDescriptor>(){

        public boolean apply(PropertyDescriptor input) {
            return !input.isHidden();
        }
    };
    private final Descriptor descriptor;
    private final boolean exposeHiddenProperties;

    public ExposedDescriptor(Descriptor descriptor) {
        this(descriptor, true);
    }

    public ExposedDescriptor(Descriptor descriptor, boolean exposeHiddenProperties) {
        this.descriptor = descriptor;
        this.exposeHiddenProperties = exposeHiddenProperties;
    }

    public Type getType() {
        return this.descriptor.getType();
    }

    public Class<?> getClazz() {
        return this.descriptor.getClazz();
    }

    public String getDescription() {
        return this.descriptor.getDescription();
    }

    public Metadata.ConfigurationItemRoot getRoot() {
        return this.descriptor.getRoot();
    }

    public Collection<PropertyDescriptor> getPropertyDescriptors() {
        if (!this.exposeHiddenProperties) {
            return ExposedDescriptor.toCollection(Iterables.filter((Iterable)this.descriptor.getPropertyDescriptors(), EXPOSED_PROPERTIES));
        }
        return this.descriptor.getPropertyDescriptors();
    }

    private static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (Collection)iterable : Lists.newArrayList(iterable.iterator());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        PropertyDescriptor propertyDescriptor = this.descriptor.getPropertyDescriptor(name);
        if (propertyDescriptor != null && propertyDescriptor.isHidden() && !this.exposeHiddenProperties) {
            return null;
        }
        return propertyDescriptor;
    }

    public MethodDescriptor getControlTask(String name) {
        return this.descriptor.getControlTask(name);
    }

    public Collection<MethodDescriptor> getControlTasks() {
        return this.descriptor.getControlTasks();
    }

    public boolean isAssignableTo(Class<?> clazz) {
        return this.descriptor.isAssignableTo(clazz);
    }

    public boolean isAssignableTo(Type type) {
        return this.descriptor.isAssignableTo(type);
    }

    public List<Type> getSuperClasses() {
        return this.descriptor.getSuperClasses();
    }

    public Set<Type> getInterfaces() {
        return this.descriptor.getInterfaces();
    }

    public boolean isVirtual() {
        return this.descriptor.isVirtual();
    }

    public boolean areEqual(ConfigurationItem item, ConfigurationItem other) {
        return this.descriptor.areEqual(item, other);
    }

    public <T extends ConfigurationItem> T newInstance() {
        return (T)this.descriptor.newInstance();
    }

    public Type getDeployableType() {
        return this.descriptor.getDeployableType();
    }

    public Type getContainerType() {
        return this.descriptor.getContainerType();
    }

    public List<ValidationMessage> validate(ConfigurationItem ci) {
        return this.descriptor.validate(ci);
    }

    public boolean isInspectable() {
        return this.descriptor.isInspectable();
    }

    public String toString() {
        return this.descriptor.toString();
    }
}

