/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.OutputSupplier;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.rest.api.DtoReader;
import com.xebialabs.deployit.core.rest.api.SearchParameterFactory;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.RoleService;
import com.xebialabs.deployit.engine.api.dto.ArtifactAndData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.engine.replacer.Placeholders;
import com.xebialabs.deployit.engine.spi.command.CreateCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.RepositoryBaseCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.internal.Root;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderScanner;
import com.xebialabs.deployit.service.replacement.PlaceholderScanningFailedException;
import com.xebialabs.deployit.service.validation.Validator;
import com.xebialabs.deployit.util.TFiles;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.javadude.t2bus.EventHandlerStrategy;
import nl.javadude.t2bus.event.strategy.ThrowingRuntimeExceptionHandlerStrategy;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class RepositoryResource
extends AbstractSecuredResource
implements com.xebialabs.deployit.engine.api.RepositoryService {
    public static final Predicate<String> canRead = new Predicate<String>(){

        public boolean apply(String input) {
            return Permission.READ.getPermissionHandler().hasPermission(input);
        }
    };
    public static final Predicate<ConfigurationItemData> hasReadRight = new Predicate<ConfigurationItemData>(){

        public boolean apply(ConfigurationItemData input) {
            return Permission.READ.getPermissionHandler().hasPermission(input.getId());
        }
    };
    public static final Predicate<ConfigurationItem> canEdit = new Predicate<ConfigurationItem>(){

        public boolean apply(ConfigurationItem input) {
            return Permission.EDIT_REPO.getPermissionHandler().hasPermission(input.getId());
        }
    };
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private Validator validator;
    @Autowired
    private RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(RepositoryResource.class);

    public ConfigurationItem create(String id, ConfigurationItem ci) {
        this.checkPermission(Permission.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.createInternal(ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Workdir
    public ConfigurationItem create(String id, ArtifactAndData aad) {
        this.checkPermission(Permission.EDIT_REPO, id);
        Artifact artifact = aad.getArtifact();
        Checks.checkArgument((boolean)id.equals(artifact.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{artifact.getId(), id});
        try {
            artifact.setFile((OverthereFile)RepositoryResource.readArtifactData(aad, WorkdirHolder.get()));
            if (artifact instanceof FolderArtifact) {
                Checks.checkTrue((boolean)TFiles.isArchive((String)artifact.getFile().getPath()), (String)"Folder artifact [%s] is not a valid ZIP archive", (Object[])new Object[]{artifact.getFile().getName()});
            }
            if (artifact instanceof SourceArtifact) {
                try {
                    Placeholders.scanPlaceholders((SourceArtifact)((SourceArtifact)artifact), (PlaceholderScanner)new MustachePlaceholderScanner());
                }
                catch (RuntimeException re) {
                    PlaceholderScanningFailedException.throwException((String)artifact.getId(), (RuntimeException)re);
                }
            }
            ConfigurationItem configurationItem = this.createInternal((ConfigurationItem)artifact);
            return configurationItem;
        }
        finally {
            WorkdirHolder.get().delete();
        }
    }

    private static LocalFile readArtifactData(ArtifactAndData aad, WorkDir workDir) {
        Checks.checkArgument((aad.getFilename() != null ? 1 : 0) != 0, (String)"The filename for the artifact should not be null", (Object[])new Object[0]);
        final LocalFile localFile = workDir.newFile(aad.getFilename());
        try {
            ByteStreams.write((byte[])aad.getData(), (OutputSupplier)new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return localFile.getOutputStream();
                }
            });
        }
        catch (IOException e) {
            throw new DeployitException("Could not write Artifact data for [" + aad.getArtifact().getId() + "] to [" + localFile + "]");
        }
        return localFile;
    }

    public List<ConfigurationItem> create(List<ConfigurationItem> cis) {
        List transform = Lists.transform(cis, (Function)new Function<ConfigurationItem, String>(){

            public String apply(ConfigurationItem from) {
                return from.getId();
            }
        });
        for (String s : transform) {
            this.checkPermission(Permission.EDIT_REPO, s);
        }
        return this.createInternal(cis);
    }

    public ConfigurationItem read(String id) {
        this.checkPermission(Permission.READ, id);
        return this.repositoryService.read(id);
    }

    public List<ConfigurationItem> read(List<String> ids) {
        ArrayList result = Lists.newArrayList();
        Collection datas = Collections2.filter(ids, canRead);
        for (String data : datas) {
            try {
                ConfigurationItem entity = this.repositoryService.read(data);
                result.add(entity);
            }
            catch (RuntimeException re) {
                logger.error("Could not read configuration item [{}]", (Object)data);
                logger.error("Exception was: ", (Throwable)re);
            }
        }
        return result;
    }

    public ConfigurationItem move(String id, String newLocation) {
        this.checkPermission(Permission.EDIT_REPO, id);
        ConfigurationItem entity = this.repositoryService.read(id);
        this.repositoryService.move(entity, newLocation);
        return this.read(newLocation);
    }

    public ConfigurationItem rename(String id, String newName) {
        this.checkPermission(Permission.EDIT_REPO, id);
        ConfigurationItem read = this.repositoryService.read(id);
        if (read.getType().equals((Object)Type.valueOf(Root.class))) {
            throw new DeployitException("Cannot rename a core.Root configuration item");
        }
        this.repositoryService.rename(id, newName);
        return this.repositoryService.read(id.substring(0, id.lastIndexOf(47) + 1) + newName);
    }

    public List<ConfigurationItemId> query(Type type, String parent, String namePattern, DateTime lastModifiedBefore, DateTime lastModifiedAfter, long page, long resultPerPage) {
        SearchParameters searchParam = SearchParameterFactory.createSearchParam(type, page, resultPerPage, parent, namePattern, lastModifiedBefore != null ? lastModifiedBefore.toGregorianCalendar() : null);
        FluentIterable filter = FluentIterable.from((Iterable)this.repositoryService.list(searchParam)).filter(hasReadRight).transform(DtoReader.ciDataToCiId);
        return Lists.newArrayList((Iterable)filter);
    }

    public List<ConfigurationItem> validate(List<ConfigurationItem> cis) {
        this.validator.validateCis(cis);
        return cis;
    }

    public ConfigurationItem update(String id, ConfigurationItem ci) {
        this.checkPermission(Permission.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(ci.getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{ci.getId(), id});
        return this.updateInternal(ci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Workdir
    public ConfigurationItem update(String id, ArtifactAndData aad) {
        this.checkPermission(Permission.EDIT_REPO, id);
        Checks.checkArgument((boolean)id.equals(aad.getArtifact().getId()), (String)"The Configuration item id is [%s], but the id parameter is [%s]", (Object[])new Object[]{aad.getArtifact().getId(), id});
        try {
            aad.getArtifact().setFile((OverthereFile)RepositoryResource.readArtifactData(aad, WorkdirHolder.get()));
            ConfigurationItem configurationItem = this.updateInternal((ConfigurationItem)aad.getArtifact());
            return configurationItem;
        }
        finally {
            WorkdirHolder.get().delete();
        }
    }

    public List<ConfigurationItem> update(List<ConfigurationItem> configurationItems) {
        Collection filter = Collections2.filter(configurationItems, canEdit);
        for (ConfigurationItem configurationItem : filter) {
            if (this.repositoryService.exists(configurationItem.getId())) {
                ConfigurationItem previous = this.repositoryService.read(configurationItem.getId(), false);
                this.publishCommand((RepositoryBaseCommand)new UpdateCiCommand(previous, configurationItem));
                continue;
            }
            this.publishCommand((RepositoryBaseCommand)new CreateCiCommand(configurationItem));
        }
        return this.reloadEntityAndCreateSuccessResponse(filter);
    }

    public void delete(String id) {
        if (Permission.IMPORT_REMOVE.isApplicableTo(id)) {
            this.checkPermission(Permission.IMPORT_REMOVE, id);
        } else {
            this.checkPermission(Permission.EDIT_REPO, id);
        }
        this.repositoryService.delete(new String[]{id});
    }

    public Boolean exists(String id) {
        return this.repositoryService.exists(id);
    }

    private ConfigurationItem createInternal(ConfigurationItem ci) {
        this.validator.validateCi(ci);
        this.publishCommand((RepositoryBaseCommand)new CreateCiCommand(ci));
        return this.repositoryService.read(ci.getId());
    }

    private List<ConfigurationItem> createInternal(List<ConfigurationItem> cis) {
        this.validator.validateCis(cis);
        CreateCisCommand event = new CreateCisCommand(cis);
        this.publishCommand((RepositoryBaseCommand)event);
        return this.reloadEntityAndCreateSuccessResponse(cis);
    }

    private void publishCommand(RepositoryBaseCommand event) {
        List roles = this.roleService.listMyRoles();
        event.setSecurityContext(Permissions.getAuthenticatedUserName(), roles);
        EventBusHolder.publish((Object)event, (EventHandlerStrategy)new ThrowingRuntimeExceptionHandlerStrategy());
    }

    private List<ConfigurationItem> reloadEntityAndCreateSuccessResponse(Collection<ConfigurationItem> cis) {
        ArrayList reloaded = Lists.newArrayList();
        for (ConfigurationItem ci : cis) {
            ConfigurationItem reloadedCi = this.repositoryService.read(ci.getId());
            reloaded.add(reloadedCi);
        }
        return reloaded;
    }

    private ConfigurationItem updateInternal(ConfigurationItem ci) {
        this.validator.validateCi(ci);
        ConfigurationItem previous = this.repositoryService.read(ci.getId(), false);
        this.publishCommand((RepositoryBaseCommand)new UpdateCiCommand(previous, ci));
        return this.repositoryService.read(ci.getId());
    }
}

