/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.booter.local.LocalDescriptor;
import com.xebialabs.deployit.booter.local.SyntheticHelper;
import com.xebialabs.deployit.booter.local.TypeDefinitions;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class TypeSystemBootstrapper {
    private static final Logger logger = LoggerFactory.getLogger(TypeSystemBootstrapper.class);

    TypeSystemBootstrapper() {
    }

    static void bootstrap() {
        logger.info("Bootstrapping the Deployit Type System.");
        TypeDefinitions typeDefs = new TypeDefinitions();
        TypeSystemBootstrapper.scanClasses(typeDefs);
        TypeSystemBootstrapper.scanSynthetics(typeDefs);
        TypeSystemBootstrapper.createTypeTree(typeDefs);
        TypeSystemBootstrapper.registerTypeDefinitions(typeDefs);
    }

    private static void createTypeTree(TypeDefinitions typeDefs) {
        for (TypeDefinitions.TypeDefinition typeDefinition : typeDefs.getDefinitions()) {
            typeDefinition.registerTypeTree();
        }
    }

    static void verifyTypes(Verifications verifications) {
        for (Descriptor descriptor : FluentIterable.from((Iterable)DescriptorRegistry.getDescriptors()).filter((Predicate)new Predicate<Descriptor>(){

            public boolean apply(Descriptor input) {
                return !input.isVirtual();
            }
        })) {
            ((LocalDescriptor)descriptor).verify(verifications);
        }
    }

    private static void scanClasses(TypeDefinitions typeDefs) {
        typeDefs.defineType(ConfigurationItem.class);
        Set cis = Scannit.getInstance().getSubTypesOf(ConfigurationItem.class);
        for (Class ci : cis) {
            typeDefs.defineType(ci);
        }
    }

    private static void scanSynthetics(TypeDefinitions typeDefs) {
        try {
            ArrayList types = Lists.newArrayList();
            ArrayList typeModifications = Lists.newArrayList();
            TypeSystemBootstrapper.readSynthetics("synthetic.xml", types, typeModifications);
            TypeSystemBootstrapper.readSynthetics("synthetic-test.xml", types, typeModifications);
            TypeSystemBootstrapper.parseAllTypeDefinitions(types, typeDefs);
            TypeSystemBootstrapper.parseAllTypeModifications(typeDefs, typeModifications);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not read synthetic type definitions.", ex);
        }
    }

    private static void registerTypeDefinitions(TypeDefinitions typeDefs) {
        for (TypeDefinitions.TypeDefinition typeDefinition : typeDefs.getDefinitions()) {
            typeDefinition.register(typeDefs);
        }
    }

    private static void parseAllTypeDefinitions(List<Element> types, TypeDefinitions typeDefs) {
        for (Element type : types) {
            typeDefs.defineType(type);
            Iterator<Element> generatedTypes = SyntheticHelper.childByName(type, (Predicate<String>)Predicates.equalTo((Object)"generate-deployable"));
            if (!generatedTypes.hasNext()) continue;
            typeDefs.defineGeneratedType(generatedTypes.next(), type);
        }
    }

    private static void parseAllTypeModifications(TypeDefinitions typeDefs, List<Element> typeModifications) {
        for (Element typeModification : typeModifications) {
            typeDefs.modifyType(typeModification);
        }
    }

    private static void readSynthetics(String name, List<Element> typeDefinitionCollector, List<Element> typeModificationsCollector) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> syntheticXMLs = cl.getResources(name);
        while (syntheticXMLs.hasMoreElements()) {
            URL syntheticXML = syntheticXMLs.nextElement();
            logger.debug("Scanning synthetic XML: {}", (Object)syntheticXML);
            Element docElement = SyntheticHelper.readSyntheticDocument(syntheticXML).getDocumentElement();
            Iterators.addAll(typeDefinitionCollector, SyntheticHelper.childByName(docElement, (Predicate<String>)Predicates.equalTo((Object)"type")));
            Iterators.addAll(typeModificationsCollector, SyntheticHelper.childByName(docElement, (Predicate<String>)Predicates.equalTo((Object)"type-modification")));
        }
    }
}

