/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api.legacy;

import com.xebialabs.deployit.engine.api.execution.TaskState;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class TaskInfo {
    private final TaskState task;

    public TaskInfo(TaskState task) {
        this.task = task;
    }

    public static List<TaskInfo> asList(List<TaskState> tasks) {
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>(tasks.size());
        for (TaskState task : tasks) {
            result.add(new TaskInfo(task));
        }
        return result;
    }

    public TaskState getTaskState() {
        return this.task;
    }

    public String getId() {
        return this.task.getId();
    }

    public String getLabel() {
        return this.task.getDescription();
    }

    public String getState() {
        return this.task.getState().toString();
    }

    public Calendar getStartDate() {
        return this.task.getStartDate() != null ? this.task.getStartDate().toGregorianCalendar() : null;
    }

    public Calendar getCompletionDate() {
        return this.task.getCompletionDate() != null ? this.task.getCompletionDate().toGregorianCalendar() : null;
    }

    public int getNrOfSteps() {
        return this.task.getNrSteps();
    }

    public int getCurrentStepNr() {
        return this.task.getCurrentStepNr();
    }

    public String getUser() {
        return this.task.getOwner();
    }

    public String getApplication() {
        return (String)this.task.getMetadata().get("application");
    }

    public String getVersion() {
        return (String)this.task.getMetadata().get("version");
    }

    public String getEnvironment() {
        return (String)this.task.getMetadata().get("environment");
    }

    public int getFailureCount() {
        return this.task.getFailureCount();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.getId()).append("label", (Object)this.getLabel()).append("state", (Object)this.getState()).append("startDate", (Object)this.getStartDate()).append("completionDate", (Object)this.getCompletionDate()).append("nrOfSteps", this.getNrOfSteps()).append("currentStepNr", this.getCurrentStepNr()).append("user", (Object)this.getUser()).append("application", (Object)this.getApplication()).append("version", (Object)this.getVersion()).append("environment", (Object)this.getEnvironment()).append("failureCount", this.getFailureCount()).toString();
    }
}

