/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.google.common.base.Strings;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CiJsonWriter
implements CiWriter {
    private final Writer writer;
    private final JsonWriter json;

    public CiJsonWriter() {
        this(new StringWriter());
    }

    public CiJsonWriter(Writer writer) {
        this.writer = writer;
        this.json = new JsonWriter(writer);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String toString() {
        return this.writer.toString();
    }

    @Override
    public void startList() {
        this.json.array();
    }

    @Override
    public void endList() {
        this.json.endArray();
    }

    @Override
    public void startCi(String type, String id) {
        this.json.object();
        this.json.key("type").value(type);
        this.json.key("id").value(id);
    }

    @Override
    public void endCi() {
        this.json.endObject();
    }

    @Override
    public void token(String token) {
        this.json.key("$token").value(Strings.nullToEmpty((String)token));
    }

    @Override
    public void startProperty(String name) {
        this.json.key(name);
    }

    @Override
    public void endProperty() {
    }

    @Override
    public void valueAsString(Object value) {
        this.json.value(value);
    }

    @Override
    public void valuesAsStrings(Collection<?> values) {
        this.json.array();
        for (Object item : values) {
            this.valueAsString(item);
        }
        this.json.endArray();
    }

    @Override
    public void mapAsStrings(Map<?, ?> map) {
        this.json.object();
        for (Object key : map.keySet()) {
            this.json.key(String.valueOf(key));
            this.valueAsString(map.get(key));
        }
        this.json.endObject();
    }

    @Override
    public void ciReference(String reference) {
        this.valueAsString(reference);
    }

    @Override
    public void ciReferences(Collection<String> references) {
        this.valuesAsStrings(references);
    }

    @Override
    public void typedCiReference(ConfigurationItemId ci) {
        this.json.object();
        this.json.key("ci").value(ci.getId());
        if (ci.getType() != null) {
            this.json.key("type").value(ci.getType());
        }
        this.json.endObject();
    }

    @Override
    public void typedCiReferences(Collection<ConfigurationItemId> references) {
        this.json.array();
        for (ConfigurationItemId item : references) {
            this.typedCiReference(item);
        }
        this.json.endArray();
    }

    @Override
    public void validationMessages(List<ValidationMessage> validations) {
        this.json.key("validation-messages");
        this.json.array();
        for (ValidationMessage validation : validations) {
            this.json.object();
            this.json.key("ci").value(validation.getCiId());
            if (validation.getPropertyName() != null) {
                this.json.key("property").value(validation.getPropertyName());
            }
            this.json.key("message").value(validation.getMessage());
            this.json.endObject();
        }
        this.json.endArray();
    }
}

