/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.tasker.Engine;
import com.xebialabs.deployit.engine.tasker.Task;
import com.xebialabs.deployit.engine.tasker.TaskExecutionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.service.deployment.DeploymentService;
import com.xebialabs.deployit.service.deployment.PartialCommitTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RollbackService {
    private Engine engine;
    private DeploymentService deploymentService;
    private static final Logger logger = LoggerFactory.getLogger(RollbackService.class);

    @Autowired
    public RollbackService(Engine engine, DeploymentService deploymentService) {
        this.engine = engine;
        this.deploymentService = deploymentService;
    }

    public TaskSpecification rollback(Task task) {
        logger.debug("Going to rollback task {}", (Object)task.getId());
        TaskExecutionContext context = task.getContext();
        WorkdirCleanerTrigger workdirCleanerTrigger = this.getAndUnregisterWorkdirCleaner(context);
        PartialCommitTrigger partialCommitTrigger = this.getPartialCommitTrigger(context);
        this.archive(task);
        DeltaSpecification deltaSpecification = partialCommitTrigger.getSpecification();
        DeployedApplication newDeployedApplication = this.findNewDeployedApplication(task, deltaSpecification, partialCommitTrigger.getInprogressDeployedApplication());
        TaskSpecification rollbackSpecification = this.createRollbackSpecification(task, deltaSpecification, newDeployedApplication, workdirCleanerTrigger.getWorkDirs());
        TaskMetadata.putMetadata(rollbackSpecification, "taskType", TaskType.ROLLBACK.name());
        TaskMetadata.putMetadata(rollbackSpecification, "rollbackTask", task.getId());
        return rollbackSpecification;
    }

    private TaskSpecification createRollbackSpecification(Task task, DeltaSpecification deltaSpecification, DeployedApplication newDeployedApplication, List<WorkDir> workDirs) {
        DeployedApplication previousDeployedApplication = deltaSpecification.getPreviousDeployedApplication();
        DeltaSpecification newDeltaSpecification = null;
        switch (deltaSpecification.getOperation()) {
            case CREATE: {
                newDeltaSpecification = this.deploymentService.prepareUndeployment(newDeployedApplication);
                break;
            }
            case DESTROY: {
                if (task.getState() == TaskExecutionState.DONE) {
                    newDeltaSpecification = this.deploymentService.prepareInitialDeployment(previousDeployedApplication);
                    break;
                }
                newDeltaSpecification = this.deploymentService.prepareUpgradeDeployment(previousDeployedApplication, newDeployedApplication);
                break;
            }
            case MODIFY: {
                if (RepositoryServiceHolder.getRepositoryService().exists(newDeployedApplication.getId())) {
                    newDeltaSpecification = this.deploymentService.prepareUpgradeDeployment(previousDeployedApplication, newDeployedApplication);
                    break;
                }
                logger.info("The update deployment was rolled back when there were no deployeds left, fully redeploying the previous deployment.");
                newDeltaSpecification = this.deploymentService.prepareInitialDeployment(previousDeployedApplication);
                break;
            }
            case NOOP: {
                throw new IllegalStateException("DeltaSpecification can never have a NOOP operation.");
            }
        }
        return this.deploymentService.getTaskSpecification(newDeltaSpecification, workDirs.toArray(new WorkDir[workDirs.size()]));
    }

    private WorkdirCleanerTrigger getAndUnregisterWorkdirCleaner(TaskExecutionContext context) {
        String name = WorkdirCleanerTrigger.class.getName();
        WorkdirCleanerTrigger trigger = (WorkdirCleanerTrigger)context.getAttribute(name);
        context.unsetAttribute(name);
        return trigger;
    }

    private PartialCommitTrigger getPartialCommitTrigger(TaskExecutionContext context) {
        String name = PartialCommitTrigger.class.getName();
        return (PartialCommitTrigger)context.getAttribute(name);
    }

    private void archive(Task task) {
        if (task.getState() == TaskExecutionState.EXECUTED) {
            this.engine.archive(task.getId());
        } else if (task.getState() == TaskExecutionState.STOPPED) {
            this.engine.cancel(task.getId());
        } else {
            throw new IllegalStateException(String.format("Can only rollback a STOPPED or EXECUTED task [%s (%s)]", task.getId(), task.getState()));
        }
    }

    private DeployedApplication findNewDeployedApplication(Task task, DeltaSpecification deltaSpecification, DeployedApplication inprogressDeployedApplication) {
        if (task.getState() == TaskExecutionState.CANCELLED) {
            return inprogressDeployedApplication;
        }
        if (task.getState() == TaskExecutionState.DONE) {
            return deltaSpecification.getDeployedApplication();
        }
        throw new IllegalStateException(String.format("Task %s should be CANCELLED or DONE now, not [%s].", task.getId(), task.getState()));
    }
}

