/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployed;
import com.xebialabs.deployit.plugin.api.udm.EmbeddedDeployedContainer;
import com.xebialabs.deployit.repository.ChangeSet;
import java.util.Collection;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeSetBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ChangeSetBuilder.class);

    public static ChangeSet determineChanges(DeltaSpecification specification) {
        ChangeSet changeSet = new ChangeSet();
        ChangeSetBuilder.addDeployedApplication(changeSet, specification);
        for (Delta delta : specification.getDeltas()) {
            switch (delta.getOperation()) {
                case CREATE: {
                    changeSet.create((ConfigurationItem)delta.getDeployed());
                    ChangeSetBuilder.addEmbeddeds(changeSet, delta.getDeployed(), Operation.CREATE);
                    specification.getDeployedApplication().addDeployed(delta.getDeployed());
                    logger.debug("The CI {} will be {} in the repository", (Object)delta.getDeployed().getId(), (Object)delta.getOperation());
                    break;
                }
                case MODIFY: 
                case NOOP: {
                    changeSet.update((ConfigurationItem)delta.getDeployed());
                    ChangeSetBuilder.addEmbeddeds(changeSet, delta.getDeployed(), delta.getOperation());
                    specification.getDeployedApplication().addDeployed(delta.getDeployed());
                    logger.debug("The CI {} will be {} in the repository", (Object)delta.getDeployed().getId(), (Object)delta.getOperation());
                    break;
                }
                case DESTROY: {
                    changeSet.delete((ConfigurationItem)delta.getPrevious());
                    ChangeSetBuilder.addEmbeddeds(changeSet, delta.getPrevious(), Operation.DESTROY);
                    logger.debug("The CI {} will be {} in the repository", (Object)delta.getPrevious().getId(), (Object)delta.getOperation());
                }
            }
        }
        logger.debug("DeployedApplication {} will contain the following deployeds {}", (Object)specification.getDeployedApplication(), (Object)specification.getDeployedApplication().getDeployeds());
        return changeSet;
    }

    private static void addEmbeddeds(ChangeSet changeSet, EmbeddedDeployedContainer<?, ?> edc, Operation operation) {
        logger.debug("Going to scan whether {}[{}] has embeddeds", (Object)edc.getType(), (Object)edc.getId());
        for (PropertyDescriptor propertyDescriptor : edc.getType().getDescriptor().getPropertyDescriptors()) {
            logger.trace("Analyzing property [{}]", (Object)propertyDescriptor.getFqn());
            if (!ChangeSetBuilder.isEmbeddedProperty(propertyDescriptor)) {
                logger.trace("[{}] is not an embedded property", (Object)propertyDescriptor.getFqn());
                continue;
            }
            logger.debug("Determining changeset for embeddeds in property {} of {}", (Object)propertyDescriptor.getFqn(), (Object)edc.getId());
            Collection embeddeds = (Collection)propertyDescriptor.get(edc);
            if (embeddeds == null || embeddeds.isEmpty()) continue;
            for (EmbeddedDeployed embedded : embeddeds) {
                switch (operation) {
                    case CREATE: {
                        changeSet.create((ConfigurationItem)embedded);
                        logger.debug("The CI {} will be {} in the repository", (Object)embedded.getId(), (Object)operation);
                        ChangeSetBuilder.addEmbeddeds(changeSet, embedded, operation);
                        break;
                    }
                    case DESTROY: {
                        logger.debug("The CI {} will be {} in the repository", (Object)embedded.getId(), (Object)operation);
                        break;
                    }
                    case MODIFY: 
                    case NOOP: {
                        changeSet.update((ConfigurationItem)embedded);
                        logger.debug("The CI {} will be {} in the repository", (Object)embedded.getId(), (Object)operation);
                        ChangeSetBuilder.addEmbeddeds(changeSet, embedded, operation);
                    }
                }
            }
        }
    }

    private static boolean isEmbeddedProperty(PropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.isAsContainment() && EnumSet.of(PropertyKind.SET_OF_CI, PropertyKind.LIST_OF_CI).contains(propertyDescriptor.getKind()) && propertyDescriptor.getReferencedType().isSubTypeOf(Type.valueOf(EmbeddedDeployed.class));
    }

    private static void addDeployedApplication(ChangeSet changeSet, DeltaSpecification specification) {
        DeployedApplication deployedApplication = specification.getDeployedApplication();
        switch (specification.getOperation()) {
            case CREATE: {
                changeSet.create((ConfigurationItem)deployedApplication);
                break;
            }
            case MODIFY: {
                changeSet.update((ConfigurationItem)deployedApplication);
                break;
            }
            case DESTROY: {
                changeSet.delete((ConfigurationItem)deployedApplication);
                break;
            }
        }
    }
}

