/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkDir
implements Serializable {
    private AtomicInteger uniqueDir = new AtomicInteger(0);
    private final LocalFile workDir;
    private static final Logger logger = LoggerFactory.getLogger(WorkDir.class);

    public WorkDir(LocalFile workDir) {
        this.workDir = workDir;
    }

    public LocalFile newFile(String filename) {
        Preconditions.checkState((boolean)this.workDir.exists(), (String)"Cannot create a new file when workDir [%s] does not exist.", (Object[])new Object[]{this.workDir});
        return this.newUniqueFile(filename);
    }

    private LocalFile newUniqueFile(String filename) {
        OverthereFile artifactDir = this.getArtifactDir();
        while (artifactDir.exists()) {
            artifactDir = this.getArtifactDir();
        }
        artifactDir.mkdir();
        return (LocalFile)artifactDir.getFile(filename);
    }

    private OverthereFile getArtifactDir() {
        return this.workDir.getFile("artifact-" + this.uniqueDir.getAndIncrement());
    }

    public String getPath() {
        return this.workDir.getPath();
    }

    public void delete() {
        logger.debug("Deleting workDir {}", (Object)this);
        if (this.workDir.exists()) {
            this.workDir.deleteRecursively();
            Preconditions.checkState((!this.workDir.exists() ? 1 : 0) != 0, (String)"Workdirectory %s should have been deleted.", (Object[])new Object[]{this});
        } else {
            logger.warn("Workdirectory {} already deleted.", (Object)this);
        }
    }

    public String toString() {
        return "WorkDir[" + this.getPath() + "]";
    }
}

