/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.core.rest.resteasy.WorkdirHolder;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.ControlService;
import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.engine.spi.event.TaskCreatedEvent;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.engine.tasker.Engine;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.service.controltask.ControlTaskService;
import com.xebialabs.deployit.service.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ControlTaskResource
extends AbstractSecuredResource
implements ControlService {
    @Autowired
    private RepositoryService repository;
    @Autowired
    private ControlTaskService controlTaskService;
    @Autowired
    private Engine engine;
    @Autowired
    private Validator validator;

    public Control prepare(String controlName, String id) {
        this.checkPermission(DeployitPermissions.CONTROLTASK_EXECUTE, id);
        ConfigurationItem configurationItem = this.repository.read(id);
        MethodDescriptor controlTask = configurationItem.getType().getDescriptor().getControlTask(controlName);
        if (controlTask == null) {
            throw new InvalidControlException("Control [%s] could  not be found on type [%s]", controlName, configurationItem.getType());
        }
        Parameters params = null;
        if (controlTask.getParameterObjectType() != null) {
            params = (Parameters)controlTask.getParameterObjectType().getDescriptor().newInstance("parameters");
        }
        return new Control(configurationItem, controlName, params);
    }

    @Workdir
    public String createTask(Control control) {
        this.checkPermission(DeployitPermissions.CONTROLTASK_EXECUTE, control.getConfigurationItem().getId());
        this.validate(control);
        try {
            TaskSpecification taskSpecification = this.controlTaskService.prepareControlTask(control.getConfigurationItem(), control.getControlName(), control.getParameters(), WorkdirHolder.get());
            String taskId = this.engine.register(taskSpecification);
            EventBusHolder.publish((Object)new TaskCreatedEvent(taskId, control.getControlName(), control.getConfigurationItem().getId()));
            return taskId;
        }
        catch (RuntimeException e) {
            WorkdirHolder.get().delete();
            throw e;
        }
    }

    private void validate(Control control) {
        if (control.getParameters() != null) {
            this.validator.validateCi((ConfigurationItem)control.getParameters());
        }
    }

    @HttpResponseCodeResult(statusCode=400)
    public static class InvalidControlException
    extends DeployitException {
        public InvalidControlException(String messageTemplate, Object ... params) {
            super(messageTemplate, params);
        }
    }
}

