/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.OperatingSystemFamily;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;

public class CmdLine
implements Serializable {
    List<CmdLineArgument> arguments = Lists.newArrayList();

    public CmdLine addArgument(String arg) {
        this.arguments.add(CmdLineArgument.arg(arg));
        return this;
    }

    public CmdLine addPassword(String arg) {
        this.arguments.add(CmdLineArgument.password(arg));
        return this;
    }

    public CmdLine addRaw(String arg) {
        this.arguments.add(CmdLineArgument.raw(arg));
        return this;
    }

    public CmdLine addTemplatedFragment(String template, Object ... variables) {
        for (String arg : template.split("\\s+")) {
            String fragment = MessageFormat.format(arg, variables);
            this.addArgument(fragment);
        }
        return this;
    }

    public CmdLine addNested(CmdLine commandLine) {
        this.arguments.add(CmdLineArgument.nested(commandLine));
        return this;
    }

    public CmdLine add(CmdLineArgument arg) {
        Preconditions.checkNotNull((Object)arg, (Object)"Cannot add null CmdLineArgument");
        this.arguments.add(arg);
        return this;
    }

    public CmdLine add(List<CmdLineArgument> args) {
        Preconditions.checkNotNull(args, (Object)"Cannot add null List<CmdLineArgument>");
        this.arguments.addAll(args);
        return this;
    }

    public List<CmdLineArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String[] toCommandArray(final OperatingSystemFamily os, final boolean forLogging) {
        Preconditions.checkState((this.arguments.size() > 0 ? 1 : 0) != 0, (Object)"Cannot encode empty command line");
        return Lists.transform(this.arguments, (Function)new Function<CmdLineArgument, String>(){

            public String apply(CmdLineArgument from) {
                return from.toString(os, forLogging);
            }
        }).toArray(new String[this.arguments.size()]);
    }

    public String toCommandLine(OperatingSystemFamily os, boolean forLogging) {
        Preconditions.checkState((this.arguments.size() > 0 ? 1 : 0) != 0, (Object)"Cannot encode empty command line");
        StringBuilder sb = new StringBuilder();
        for (CmdLineArgument a : this.arguments) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            a.buildString(os, forLogging, sb);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toCommandLine(OperatingSystemFamily.UNIX, true);
    }

    public static CmdLine build(String ... args) {
        CmdLine cmdLine = new CmdLine();
        for (String s : args) {
            cmdLine.addArgument(s);
        }
        return cmdLine;
    }
}

