/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DeploymentPlanner;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.planning.Noop;
import com.xebialabs.deployit.plugin.api.deployment.planning.PostPlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.reflect.ReflectionsHolder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DeploymentPlannerFactory {
    public DeploymentPlanner planner() {
        ListMultimap<Operation, Method> deployedContributors = this.registerDeployedContributors();
        Set<Method> contributors = this.checkContributors(ReflectionsHolder.getMethodsAnnotatedWith(Contributor.class));
        ArrayList preProcessors = Lists.newArrayList(this.checkProcessors(ReflectionsHolder.getMethodsAnnotatedWith(PrePlanProcessor.class)));
        ArrayList postProcessors = Lists.newArrayList(this.checkProcessors(ReflectionsHolder.getMethodsAnnotatedWith(PostPlanProcessor.class)));
        return new DeploymentPlanner.DeploymentPlannerBuilder().preProcessors(preProcessors).postProcessors(postProcessors).typeContributors(deployedContributors).contributors(contributors).build();
    }

    private Set<Method> checkProcessors(Set<Method> processors) {
        for (Method processor : processors) {
            Preconditions.checkArgument((processor.getReturnType().equals(Step.class) || processor.getReturnType().equals(List.class) ? 1 : 0) != 0, (String)"Pre/Post processor %s should have a Step or List<Step> return type.", (Object[])new Object[]{processor});
            Class<?>[] parameterTypes = processor.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length == 1 ? 1 : 0) != 0, (String)"Processor %s should take 1 parameter.", (Object[])new Object[]{processor});
            Preconditions.checkArgument((boolean)parameterTypes[0].equals(DeltaSpecification.class), (String)"Processor %s should take %s as first parameter.", (Object[])new Object[]{processor, DeltaSpecification.class});
        }
        return processors;
    }

    private Set<Method> checkDeployedContributors(Set<Method> deployedContributors) {
        for (Method c : deployedContributors) {
            Preconditions.checkArgument((boolean)c.getReturnType().equals(Void.TYPE), (String)"DeployedContributor %s should have void return type.", (Object[])new Object[]{c});
            Class<?>[] parameterTypes = c.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length <= 2 && parameterTypes.length >= 1 ? 1 : 0) != 0, (String)"DeployedContributor %s should take 1 or 2 parameters.", (Object[])new Object[]{c});
            Preconditions.checkArgument((boolean)parameterTypes[0].equals(DeploymentPlanningContext.class), (String)"DeployedContributor %s should take %s as first parameter.", (Object[])new Object[]{c, DeploymentPlanningContext.class});
            if (parameterTypes.length != 2) continue;
            Preconditions.checkArgument((boolean)parameterTypes[1].equals(Delta.class), (String)"DeployedContributor %s should take %s as first parameter.", (Object[])new Object[]{c, Delta.class});
        }
        return deployedContributors;
    }

    private Set<Method> checkContributors(Set<Method> contributors) {
        for (Method contributor : contributors) {
            Preconditions.checkArgument((boolean)contributor.getReturnType().equals(Void.TYPE), (String)"Contributor %s should have void return type.", (Object[])new Object[]{contributor});
            Class<?>[] parameterTypes = contributor.getParameterTypes();
            Preconditions.checkArgument((parameterTypes.length == 2 ? 1 : 0) != 0, (String)"Contributor %s should take 2 parameters.", (Object[])new Object[]{contributor});
            Preconditions.checkArgument((boolean)parameterTypes[0].equals(Deltas.class), (String)"Contributor %s should take %s as first parameter.", (Object[])new Object[]{contributor, Deltas.class});
            Preconditions.checkArgument((boolean)parameterTypes[1].equals(DeploymentPlanningContext.class), (String)"Contributor %s should take %s as second parameter.", (Object[])new Object[]{contributor, DeploymentPlanningContext.class});
        }
        return contributors;
    }

    private ListMultimap<Operation, Method> registerDeployedContributors() {
        ArrayListMultimap deployedContributorMap = ArrayListMultimap.create();
        this.registerDeployedContributors(Create.class, Operation.CREATE, (ListMultimap<Operation, Method>)deployedContributorMap);
        this.registerDeployedContributors(Modify.class, Operation.MODIFY, (ListMultimap<Operation, Method>)deployedContributorMap);
        this.registerDeployedContributors(Destroy.class, Operation.DESTROY, (ListMultimap<Operation, Method>)deployedContributorMap);
        this.registerDeployedContributors(Noop.class, Operation.NOOP, (ListMultimap<Operation, Method>)deployedContributorMap);
        return deployedContributorMap;
    }

    private void registerDeployedContributors(Class<? extends Annotation> annotation, Operation operation, ListMultimap<Operation, Method> deployedContributorMap) {
        Set<Method> typeContributors = this.checkDeployedContributors(ReflectionsHolder.getMethodsAnnotatedWith(annotation));
        for (Method typeContributor : typeContributors) {
            deployedContributorMap.put((Object)operation, (Object)typeContributor);
        }
    }
}

