package com.xebialabs.deployit.deployment.planner;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.server.api.util.IdGenerator.generateId;

import java.util.List;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Version;

public class DeltaSpecificationBuilder {

    private Operation operation = Operation.CREATE;
    private Version version;
    private Environment environment;
    private List<Delta> deltas = newArrayList();

    public static DeltaSpecificationBuilder newSpecification() {
        return new DeltaSpecificationBuilder();
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder create(Deployed d) {
        return with(Operation.CREATE, null, d);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder modify(Deployed previous, Deployed d) {
        return with(Operation.MODIFY, previous, d);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder destroy(Deployed d) {
        return with(Operation.DESTROY, d, null);
    }

    @SuppressWarnings("rawtypes")
    public DeltaSpecificationBuilder noOp(Deployed d) {
        return with(Operation.NOOP, d, d);
    }

    @SuppressWarnings("rawtypes")
    private DeltaSpecificationBuilder with(Operation operation, Deployed previous, Deployed deployed) {
        deltas.add(new DefaultDelta(operation, previous, deployed));
        return this;
    }

    public DeltaSpecificationBuilder upgrade(Version version, DeployedApplication existingDeployment) {
        this.version = version;
        this.environment = existingDeployment.getEnvironment();
        this.operation = Operation.MODIFY;
        return this;
    }

    public DeltaSpecificationBuilder undeploy(DeployedApplication existingDeployment) {
        this.version = existingDeployment.getVersion();
        this.environment = existingDeployment.getEnvironment();
        this.operation = Operation.DESTROY;
        return this;
    }

    public DeltaSpecificationBuilder initial(Version version, Environment environment) {
        this.version = version;
        this.environment = environment;
        this.operation = Operation.CREATE;
        return this;
    }

    public DeltaSpecification build() {
        DeployedApplication deployedApplication = new DeployedApplication(version, environment);
        generateId(deployedApplication);
        return new DefaultDeltaSpecification(operation, deployedApplication, deltas);
    }
}
