/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.planner;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.DefaultDeploymentPlanningContext;
import com.xebialabs.deployit.deployment.planner.Planner;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.deployment.execution.InterleavedPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.ParallelPlan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plans;
import com.xebialabs.deployit.plugin.api.deployment.execution.SerialPlan;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DeploymentPlanner
implements Planner {
    private Set<Method> contributors;
    private ListMultimap<Operation, Method> typeContributors;
    private List<Method> preProcessors;
    private List<Method> postProcessors;

    private DeploymentPlanner() {
    }

    @Override
    public Plan plan(DeltaSpecification spec) {
        Plan plan = this.orchestrate(spec);
        Plan preprocessed = this.preProcessPlan(spec);
        Plan postprocessed = this.postProcessPlan(spec);
        plan = this.resolvePlan(plan, spec);
        return Plans.serial((Plan[])new Plan[]{preprocessed, plan, postprocessed});
    }

    private Plan postProcessPlan(DeltaSpecification spec) {
        return this.processPlan(spec, this.postProcessors);
    }

    private Plan preProcessPlan(DeltaSpecification spec) {
        return this.processPlan(spec, this.preProcessors);
    }

    private Plan processPlan(DeltaSpecification spec, List<Method> processors) {
        Plans.InterleavedPlanBuilder builder = Plans.newInterleavedPlan((InterleavedPlan)Plans.interleaved((Delta[])new Delta[0]));
        for (Method processor : processors) {
            try {
                Object o = processor.getDeclaringClass().newInstance();
                this.addResultingStepToBuilder(processor.invoke(o, spec), builder, processor);
            }
            catch (InstantiationException e) {
                throw new PlannerException(e);
            }
            catch (IllegalAccessException e) {
                throw new PlannerException(e);
            }
            catch (InvocationTargetException e) {
                this.handleInvocationTargetException(e);
            }
        }
        return builder.build();
    }

    private Plan resolvePlan(Plan plan, DeltaSpecification spec) {
        if (plan instanceof ParallelPlan) {
            return this.resolveParallelPlan((ParallelPlan)plan, spec);
        }
        if (plan instanceof SerialPlan) {
            return this.resolveSerialPlan((SerialPlan)plan, spec);
        }
        Plans.InterleavedPlanBuilder planBuilder = Plans.newInterleavedPlan((InterleavedPlan)((InterleavedPlan)plan));
        this.orderedResolution((InterleavedPlan)plan, planBuilder, spec);
        return planBuilder.build();
    }

    private Plan resolveSerialPlan(SerialPlan plan, DeltaSpecification spec) {
        return Plans.serial(this.resolvePlans(plan.getPlans(), spec));
    }

    private Plan resolveParallelPlan(ParallelPlan plan, DeltaSpecification spec) {
        return Plans.parallel(this.resolvePlans(plan.getPlans(), spec));
    }

    private List<Plan> resolvePlans(List<Plan> plans, DeltaSpecification spec) {
        ArrayList resolvedPlans = Lists.newArrayList();
        for (Plan subplan : plans) {
            resolvedPlans.add(this.resolvePlan(subplan, spec));
        }
        return resolvedPlans;
    }

    private Plan orchestrate(DeltaSpecification spec) {
        return Plans.interleaved((Delta[])spec.getDeltas().toArray(new Delta[spec.getDeltas().size()]));
    }

    private void orderedResolution(InterleavedPlan plan, Plans.InterleavedPlanBuilder planBuilder, DeltaSpecification spec) {
        DefaultDeploymentPlanningContext context = new DefaultDeploymentPlanningContext(planBuilder, spec.getDeployedApplication());
        this.callTypeContributors(this.typeContributors, plan, planBuilder, context);
        this.callContributors(this.contributors, plan, planBuilder, context);
    }

    private void callTypeContributors(ListMultimap<Operation, Method> typeContributors, InterleavedPlan plan, Plans.InterleavedPlanBuilder planBuilder, DeploymentPlanningContext context) {
        if (typeContributors == null) {
            return;
        }
        for (Delta dOp : plan.getDeltas()) {
            List methods = typeContributors.get((Object)dOp.getOperation());
            Deployed<?, ?> deployed = this.getActiveDeployed(dOp);
            for (Method method : methods) {
                Type type = Type.valueOf(method.getDeclaringClass());
                if (type.equals((Object)deployed.getType())) {
                    this.invokeTypeContributer(context, dOp, method);
                    continue;
                }
                Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)deployed.getType());
                if (!descriptor.isAssignableTo(type)) continue;
                this.invokeTypeContributer(context, dOp, method);
            }
        }
    }

    private void callContributors(Set<Method> methods, InterleavedPlan plan, Plans.InterleavedPlanBuilder planBuilder, DeploymentPlanningContext context) {
        if (methods == null) {
            return;
        }
        Deltas deltas = new Deltas(plan.getDeltas());
        for (Method method : methods) {
            try {
                Object contributorInstance = method.getDeclaringClass().newInstance();
                method.invoke(contributorInstance, deltas, context);
            }
            catch (InstantiationException e) {
                throw new PlannerException(e);
            }
            catch (IllegalAccessException e) {
                throw new PlannerException(e);
            }
            catch (InvocationTargetException e) {
                this.handleInvocationTargetException(e);
            }
        }
    }

    private Deployed<?, ?> getActiveDeployed(Delta dOp) {
        if (dOp.getOperation() == Operation.DESTROY) {
            return dOp.getPrevious();
        }
        return dOp.getDeployed();
    }

    private void invokeTypeContributer(DeploymentPlanningContext planContext, Delta delta, Method method) {
        try {
            if (method.getParameterTypes().length == 2) {
                method.invoke(this.getActiveDeployed(delta), planContext, delta);
            } else {
                method.invoke(this.getActiveDeployed(delta), planContext);
            }
        }
        catch (IllegalAccessException e) {
            throw new PlannerException(e);
        }
        catch (InvocationTargetException e) {
            this.handleInvocationTargetException(e);
        }
    }

    private void handleInvocationTargetException(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            throw new PlannerException(cause.getMessage(), cause);
        }
        throw new PlannerException(e);
    }

    private void addResultingStepToBuilder(Object result, Plans.InterleavedPlanBuilder planBuilder, Method method) {
        if (result == null) {
            return;
        }
        if (result instanceof DeploymentStep) {
            planBuilder.withStep((DeploymentStep)result);
        } else if (result instanceof List) {
            planBuilder.withSteps((List)result);
        } else {
            throw new PlannerException("Result of call of %s is not of type Step of List<Step>.", method);
        }
    }

    public static class PlannerException
    extends RuntimeException {
        public PlannerException() {
        }

        public PlannerException(String message) {
            super(message);
        }

        public PlannerException(String message, Object ... params) {
            super(String.format(message, params));
        }

        public PlannerException(String message, Throwable cause) {
            super(message, cause);
        }

        public PlannerException(Throwable cause) {
            super(cause);
        }
    }

    public static class DeploymentPlannerBuilder {
        private DeploymentPlanner planner = new DeploymentPlanner();

        public DeploymentPlannerBuilder typeContributors(ListMultimap<Operation, Method> typeContributors) {
            this.planner.typeContributors = typeContributors;
            return this;
        }

        public DeploymentPlannerBuilder contributors(Set<Method> contributors) {
            this.planner.contributors = contributors;
            return this;
        }

        public DeploymentPlannerBuilder preProcessors(List<Method> preProcessors) {
            this.planner.preProcessors = preProcessors;
            return this;
        }

        public DeploymentPlannerBuilder postProcessors(List<Method> postProcessors) {
            this.planner.postProcessors = postProcessors;
            return this;
        }

        public DeploymentPlanner build() {
            return this.planner;
        }
    }
}

