package com.xebialabs.deployit.plugin.dictionary.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.artifact.mapping.ConfigurationFilesMapping;
import com.xebialabs.deployit.ci.mapping.KeyValuePair;
import com.xebialabs.deployit.plugin.dictionary.AutoFiller;

import java.util.Iterator;
import java.util.List;

@ConfigurationItem
public class AutoFillingConfigurationFilesMapping extends ConfigurationFilesMapping {

	@Override
	public void postInit(Deployment deployment) {
		final List<KeyValuePair> keyValuePairs = getKeyValuePairs();

		new AutoFiller(deployment).process(keyValuePairs);

		//remove the TARGET_DIRECTORY key & set it in the right attribute
		final Iterator<KeyValuePair> pairIterator = getKeyValuePairs().iterator();
		while (pairIterator.hasNext()) {
			final KeyValuePair pair = pairIterator.next();
			if (pair.getKey().equals(TARGET_DIRECTORY_KEY_NAME)) {
				setTargetDirectory(pair.getValue());
				pairIterator.remove();
			}
		}

	}
}
