package com.xebialabs.deployit.plugin.wls.ci;

import com.xebialabs.deployit.ConfigurationItem;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.plugin.dictionary.ArtifactAutoFiller;
import org.apache.commons.lang.StringUtils;

@ConfigurationItem
public class AutoFillingWlsClusterResourceMapping extends WlsClusterResourceMapping {

	@Override
	public void postInit(Deployment deployment) {
		final String sourceType = findSourceType();
		new ArtifactAutoFiller(deployment, sourceType).process(getSourcePropertyOverrides());
		super.postInit(deployment);
	}

	private String findSourceType() {
		final Class<? extends WlsClusterResource> aClass = this.getSource().getClass();
		final String name = aClass.getName();
		final String[] split = StringUtils.split(name, ".");
		final String lastPart = split[split.length - 1];
		final String substring = lastPart.substring("Wls".length()).toLowerCase();
		return substring;
	}
}
