package com.xebialabs.deployit.plugin.freemarker

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import freemarker.template.{DefaultObjectWrapper, TemplateModel}


class BaseCiAwareObjectWrapper(maskPasswords: Boolean = false) extends DefaultObjectWrapper {

  override def wrap(obj: scala.Any): TemplateModel = {
    if (obj != null && obj.isInstanceOf[ConfigurationItem]) {
      new BaseCiTemplateModel(obj.asInstanceOf[ConfigurationItem], this, maskPasswords)
    } else {
      super.wrap(obj)
    }
  }
}
