package com.xebialabs.deployit.plugin.steps

import com.xebialabs.deployit.plugin.api.udm.artifact.{SourceArtifact, DerivedArtifact, Artifact}
import java.util.{Map => JMap}

import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployableArtifact

/**
 * We compare Artifacts by their source checksum and the placeholder replacements that should take place.
 * @param artifact The Artifact to compare
 */
case class ArtifactKey(artifact:Artifact) {
  def getKey: Option[String] = Option(artifact)
    .collect({
      case da: DerivedArtifact[_] if
        da.getSourceArtifact != null && da.getSourceArtifact.isInstanceOf[BaseDeployableArtifact] => da.getSourceArtifact.asInstanceOf[BaseDeployableArtifact].getChecksum
      case bdA: BaseDeployableArtifact => bdA.getChecksum
  })

  def getPlaceholders: Option[JMap[String, String]] = Option(artifact).collect({
    case da: DerivedArtifact[_] => da.getPlaceholders
  })

  override def equals(obj: scala.Any): Boolean = {
    obj match {
      case key: ArtifactKey => getKey == key.getKey && getPlaceholders == key.getPlaceholders
      case _ => false
    }
  }
}