package com.xebialabs.deployit.plugin.freemarker

import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, PropertyKind}
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.base.{BaseContainer, BaseDeployed}
import com.xebialabs.deployit.plugin.freemarker.Resolver.{resolveExpression, resolveExpressions, resolveMapExpressions}
import freemarker.ext.beans.BeanModel
import freemarker.template.TemplateModel

import scala.collection.convert.wrapAll._

class CiTemplateModel(ci: ConfigurationItem, wrapper: BaseCiAwareObjectWrapper) extends BeanModel(ci, wrapper) {

  private val MASKED_PASSWORD: String = "********"

  override def get(key: String): TemplateModel = {
    val pd = ci.getType.getDescriptor.getPropertyDescriptor(key)
    if (pd != null) {
      wrapper.wrap(extractValueFromCi(pd))
    } else {
      super.get(key)
    }
  }

  private def extractValueFromCi(pd: PropertyDescriptor): AnyRef = {
    if (pd.isPassword && wrapper.maskPasswords) {
      pd.getKind match {
        case PropertyKind.SET_OF_STRING => return setAsJavaSet(Set(MASKED_PASSWORD))
        case PropertyKind.LIST_OF_STRING => return seqAsJavaList(Seq(MASKED_PASSWORD))
        case PropertyKind.MAP_STRING_STRING => return mapAsJavaMap(Map(MASKED_PASSWORD -> MASKED_PASSWORD))
        case _ => return MASKED_PASSWORD
      }
    }

    pd.get(ci)
  }

  override def isEmpty: Boolean = false
}
