package com.xebialabs.deployit.plugin.steps

import java.util.{Map => JMap, HashMap => JHashMap, Collections}

import com.xebialabs.xlplatform._
import collection.convert.wrapAsJava._
import collection.convert.wrapAsScala._

import com.xebialabs.deployit.plugin.api.rules.{Scope, StepPostConstructContext}

object ContextHelper {

  def defaultContext(ctx: StepPostConstructContext, addEntries: JMap[String, Any] = Collections.emptyMap()): JMap[String, Any] = {
    val default: Map[String, Any] = ctx.getScope match {
      case Scope.DEPLOYED => Map("deployed" -> ctx.getDelta.correctDeployed)
      case _ => Map.empty
    }
    new JHashMap(default ++ Option(addEntries).getOrElse(new JHashMap[String, Any]()))
  }
}
