package com.xebialabs.deployit.plugin

import java.util

package object freemarker {

  import scala.collection.convert.wrapAsJava._

  private[freemarker] def any2Iterable(anyRef: AnyRef) = {
    import collection.convert.wrapAsScala._
    anyRef.asInstanceOf[util.Collection[String]].toIterable
  }

  private[freemarker] def any2Map(anyRef: AnyRef) = {
    import collection.convert.wrapAsScala._
    anyRef.asInstanceOf[util.Map[String, String]].toMap
  }


  private[freemarker] def convertToJavaMap(context: AnyRef) = context match {
    case map: Map[String, _] => new util.HashMap[String, Any](map)
    case _ => context
  }
}
