#!/usr/bin/python

import pycontrol.pycontrol as pc
import getpass
import sys
from sys import argv

bigip_address = '${container.address}'
bigip_user = '${container.username}'
bigip_pass = '${container.password}'
active_partition = '${container.partition}'
poolmember_pool = '${poolmember.bigIpPool}'
poolmember_address = '${poolmember.bigIpAddress}'
poolmember_port = '${poolmember.bigIpPort}'

print 'Connecting to BIG-IP at [' + bigip_address + '] as user [' + bigip_user + ']'
bigip = pc.BIGIP(hostname = bigip_address, username = bigip_user, password = bigip_pass, fromurl = True, wsdls = ['Management.Partition', 'LocalLB.Pool', 'LocalLB.PoolMember'])

pool = bigip.LocalLB.Pool
pool_version = pool.get_version()
print 'Detected version: ' + pool_version

print 'Setting active partition to [' + active_partition + ']'
bigip.Management.Partition.set_active_partition(active_partition)

try:
    setter = pool.set_member_monitor_state
    legacy_api = 0
except AttributeError:
    legacy_api = 1

if legacy_api:
    pmem = bigip.LocalLB.PoolMember.typefactory.create('Common.IPPortDefinition')
    pmem.address = poolmember_address
    pmem.port = poolmember_port

    # monitor state
    mstate = bigip.LocalLB.PoolMember.typefactory.create('LocalLB.PoolMember.MemberMonitorState')
    mstate.member = pmem
    mstate.monitor_state = 'STATE_ENABLED'

    mstate_seq = bigip.LocalLB.PoolMember.typefactory.create('LocalLB.PoolMember.MemberMonitorStateSequence')
    mstate_seq.item = [mstate]

    print 'Enabling pool member [' + poolmember_address + ':' + poolmember_port + '] in pool [' + poolmember_pool + ']'
    bigip.LocalLB.PoolMember.set_monitor_state(pool_names = [poolmember_pool], monitor_states = [mstate_seq])

    # session state
    sstate = bigip.LocalLB.PoolMember.typefactory.create('LocalLB.PoolMember.MemberSessionState')
    sstate.member = pmem
    sstate.session_state = 'STATE_ENABLED'

    sstate_seq = bigip.LocalLB.PoolMember.typefactory.create('LocalLB.PoolMember.MemberSessionStateSequence')
    sstate_seq.item = [sstate]

    print 'Bringing pool member [' + poolmember_address + ':' + poolmember_port + '] in pool [' + poolmember_pool + '] online'
    bigip.LocalLB.PoolMember.set_session_enabled_state(pool_names = [poolmember_pool], session_states = [sstate_seq])
else:
    pmem = pool.typefactory.create('Common.AddressPort')
    pmem.address = poolmember_address
    pmem.port = int(poolmember_port)

    pmem_seq = pool.typefactory.create('Common.AddressPortSequence')
    pmem_seq.item = [pmem]

    state = pool.typefactory.create('Common.EnabledState').STATE_ENABLED
    state_seq = pool.typefactory.create('Common.EnabledStateSequence')
    state_seq.item = [state]

    # monitor state
    print 'Enabling pool member [' + poolmember_address + ':' + poolmember_port + '] in pool [' + poolmember_pool + ']'
    pool.set_member_monitor_state(pool_names = [poolmember_pool], members= [pmem_seq], monitor_states = [state_seq])

    # session state
    print 'Bringing pool member [' + poolmember_address + ':' + poolmember_port + '] in pool [' + poolmember_pool + '] online'
    pool.set_member_session_enabled_state(pool_names = [poolmember_pool], members= [pmem_seq], session_states = [state_seq])

print 'Done'
