/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.bigip;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.lb.ci.LoadBalancer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

@Metadata(root=Metadata.ConfigurationItemRoot.NESTED, virtual=false, description="An F5 BigIp LoadBalancer")
public class LocalTrafficManager
extends LoadBalancer {
    @Property(description="The address of the BigIP load balancer")
    private String address;
    @Property(description="The username used to connect to the BigIP load balancer")
    private String username;
    @Property(password=true, description="The password used to connect to the BigIP load balancer")
    private String password;
    @Property(description="The active partition on the BigIP load balancer")
    private String partition;
    @Property(defaultValue="8", hidden=true)
    private int removeFromPoolOrder = 8;
    @Property(defaultValue="big-ip/disable-pool-member.py.ftl", hidden=true)
    private String removeFromPoolScript = "big-ip/disable-pool-member.py.ftl";
    @Property(defaultValue="94", hidden=true)
    private int addToPoolOrder = 94;
    @Property(defaultValue="big-ip/enable-pool-member.py.ftl", hidden=true)
    private String addToPoolScript = "big-ip/enable-pool-member.py.ftl";
    @Property(description="The host that runs the PyControl 2 library that controls the BigIP load balancer", asContainment=true)
    private Host host;

    public void stopTraffic(Deltas deltas, DeploymentPlanningContext ctx, Set<Container> serversToDisable) {
        for (Container container : serversToDisable) {
            ScriptExecutionStep step = new ScriptExecutionStep(this.removeFromPoolOrder, this.removeFromPoolScript, (HostContainer)this, LocalTrafficManager.getFreeMarkerContext(container, (Container)this), String.format("Remove %s from load balancer pool of %s", container.getName(), this.getName()));
            this.setClasspathResources(step);
            ctx.addStep((Step)step);
        }
    }

    public void startTraffic(Deltas deltas, DeploymentPlanningContext ctx, Set<Container> serversToEnable) {
        for (Container container : serversToEnable) {
            ScriptExecutionStep step = new ScriptExecutionStep(this.addToPoolOrder, this.addToPoolScript, (HostContainer)this, LocalTrafficManager.getFreeMarkerContext(container, (Container)this), String.format("Return %s to load balancer pool of %s", container.getName(), this.getName()));
            this.setClasspathResources(step);
            ctx.addStep((Step)step);
        }
    }

    public Host getHost() {
        return this.host;
    }

    private static Map<String, Object> getFreeMarkerContext(Container container, Container loadBalancer) {
        return ImmutableMap.of((Object)"container", (Object)loadBalancer, (Object)"poolmember", (Object)container);
    }

    private void setClasspathResources(ScriptExecutionStep step) {
        ArrayList<String> resourceList = new ArrayList<String>();
        resourceList.add("bigsuds.py");
        resourceList.add("suds");
        step.setClasspathResources(resourceList);
    }
}

