$catalog = ConnectToBizTalkDatabaseCatalog $deployed.container
$rdd = $catalog.RuledeploymentDriver
$rs = $rdd.getRuleStore()

$rulesName = if($deployed.rulesName) { $deployed.rulesName } else { $deployed.name }
$ruleSetInfo = New-Object -TypeName Microsoft.RuleEngine.RuleSetInfo -ArgumentList($rulesName, $deployed.majorVersion, $deployed.minorVersion)

if(!($rs.GetRuleSet($ruleSetInfo))) {
    Write-Host "Cannot undeploy and delete version [$($deployed.majorVersion).$($deployed.minorVersion)] of rules [$rulesName] because it does not exist. Did you specify the correct name/rulesName, majorVersion and minorVersion in the package?"
    Exit 1
}

Write-Host "Undeploying version [$($deployed.majorVersion).$($deployed.minorVersion)] of rules [$rulesName]"
$rdd.Undeploy($ruleSetInfo)

Write-Host "Deleting version [$($deployed.majorVersion).$($deployed.minorVersion)] of rules [$rulesName]"
$rs.Remove($ruleSetInfo)
