# [DEPL-8832] This script adds a step to Import Biztalk bindings in NOOP when Assembly is Modified.
from sets import Set
from biztalk.modules.biztalk_helper import BiztalkHelper

helper = BiztalkHelper(context, steps)

is_assembly_modified = False
noop_bindings_set = Set()
for delta in deltas.deltas:
    deployed = delta.deployedOrPrevious
    if deployed.type == "biztalk.Bindings" and delta.operation == "NOOP":
        noop_bindings_set.add(deployed)
    if delta.operation == "MODIFY" and delta.deployed.type.isSubTypeOf(Type.valueOf('biztalk.BaseAssembly')):
        is_assembly_modified = True

if is_assembly_modified:
    helper.add_create_binding_step(noop_bindings_set)
