ConnectToBizTalkDatabase $deployed.container

cd "BizTalk4Deployit:\Applications\$($deployed.applicationName)\Resources"

Write-Host "Retrieving full name for assembly [$($deployed.name)]"
$assemblyName = [System.Reflection.AssemblyName]::GetAssemblyName($deployed.file).FullName

If (!(Test-Path $assemblyName)) {
    Write-Host "Assembly [$assemblyName] has already been removed."
    Exit 1
}

Write-Host "Removing assembly [$assemblyName] from BizTalk application [$($deployed.applicationName)]"
Remove-Item -Path $assemblyName
if(!$?) {
    Write-Host "Cannot remove assembly [$assemblyName] from BizTalk application [$($deployed.applicationName)]"
    Exit 1
}

If ($deployed.sourcePath) {
    Write-Host "Removing assembly file from source path [$($deployed.sourcePath)]"
    Remove-Item -Force $deployed.sourcePath
}

If ($deployed.destinationPath -ne $deployed.sourcePath) {
    Write-Host "Removing assembly file from destination path [$($deployed.destinationPath)]"
    Remove-Item -Force $deployed.destinationPath
}
