package com.xebialabs.deployit.plugin.cloud.util;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;

import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;

/**
 * Helper class which is responsible for providing a method to wait for marker file to appear
 */
@SuppressWarnings("serial")
public class MarkerChecker implements Serializable {

    private transient OverthereConnection connection = null;

    public void waitForMarkerFileAppears(final String protocol, final ConnectionOptions connectionOption, final String path, int timeout, int retryDelay) throws TimeoutException {
        new Retrier<Boolean>(new Callable<Boolean>() {
            @Override
            public Boolean call() throws Exception {

                if (connection == null) {
                    connection = Overthere.getConnection(protocol, connectionOption);
                }

                if (!connection.getFile(path).exists()) {
                    throw new IllegalStateException("Expect " + path + " to exist on " + connection.toString());
                }

                return true;
            }
        }).retryFor(timeout, retryDelay);
    }

}