package com.xebialabs.deployit.plugin.cloud.util;


import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * Helps to retry actions which may fail for some reason
 */
public class Retrier<T> {


    private Logger log = LoggerFactory.getLogger(Retrier.class);

    private Callable<T> action;

    /**
     * @param action action to be retired
     */
    public Retrier(final Callable<T> action) {
        this.action = action;
    }


    /**
     * Retries an action with a total timeout of {@code timeout} seconds for {@code delay} seconds delay after each attempt.
     */
    public T retryFor(int timeout, int delay) throws TimeoutException {
        int attempts = (int)Math.floor(timeout / delay) + 1;
        int a = 0;

        while (true) {
            try {
                a++;
                log.debug("Performing attempt {}", a);
                return action.call();
            } catch (Exception e) {
                if (a == attempts) {
                    throw new TimeoutException("Can not retry anymore..." +  e.getMessage());
                }

                try {
                    log.debug("Sleeping for " + delay + " s...");
                    Thread.sleep(delay * 1000);
                } catch (InterruptedException e1) {
                    // After an InterruptedException, always re-set the interrupt flag on the thread.
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e1);
                }
            }
        }
    }
}
