/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.ci;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.ci.CloudEnvironmentParameters;
import com.xebialabs.deployit.plugin.cloud.ci.WaitForInstancesStep;
import com.xebialabs.deployit.plugin.cloud.step.CheckParametersStep;
import com.xebialabs.deployit.plugin.cloud.step.RegisterEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.step.RegisterInstancesStep;
import com.xebialabs.deployit.plugin.cloud.step.ValidateDescriptorStep;
import com.xebialabs.deployit.plugin.cloud.step.rule.SingleEnvCheck;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import com.xebialabs.deployit.plugin.cloud.util.MarkerChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@Metadata(description="Cloud environment template", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class EnvironmentTemplate
extends BaseConfigurationItem {
    @Property(required=false, size=Property.Size.LARGE, label="Description of the template")
    private String description;
    @Property(required=true, label="Host templates")
    private List<BaseHostTemplate> hostTemplates;
    @Property(required=true, size=Property.Size.LARGE, label="Environment descriptor", description="Freemarker template of XML which describes environment")
    private String xmlDescriptor;
    private static InstanceDescriptorResolver descriptorResolver = new InstanceDescriptorResolver();
    private static CiParser ciParser = new CiParser();

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHostTemplates(List<BaseHostTemplate> hostTemplates) {
        this.hostTemplates = hostTemplates;
    }

    public void setXmlDescriptor(String xmlDescriptor) {
        this.xmlDescriptor = xmlDescriptor;
    }

    public List<BaseHostTemplate> getHostTemplates() {
        return this.hostTemplates;
    }

    public String getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    @ControlTask(label="Instantiate environment", parameterType="cloud.CloudEnvironmentParameters", description="Instantiate environment and all hosts, which templates are linked to this environment template")
    public List<? extends Step> instantiate(CloudEnvironmentParameters parameters) {
        ArrayList steps = Lists.newArrayList();
        steps.add(new CheckParametersStep(parameters));
        if (!this.getHostTemplates().isEmpty()) {
            int seq = 1;
            for (BaseHostTemplate template : this.getHostTemplates()) {
                steps.addAll(template.produceCreateSteps(this.getName(), seq));
                ++seq;
            }
            steps.add(new WaitForInstancesStep(new MarkerChecker()));
            steps.add(new RegisterInstancesStep(descriptorResolver, ciParser, parameters.getHostsPath()));
        }
        steps.add(new RegisterEnvironmentStep(descriptorResolver, ciParser, this, parameters.getEnvironmentId()));
        return steps;
    }

    @ControlTask(label="Validate descriptor", description="Validate XML descriptor of the environment template")
    public List<? extends Step> validateEnvironmentDescriptor() {
        HashMap scope = Maps.newHashMap();
        scope.put("environmentId", "Environments/descriptorTestEnv");
        scope.put("hosts", Collections.emptyList());
        scope.put("environmentTemplate", this);
        return Lists.newArrayList((Object[])new ValidateDescriptorStep[]{new ValidateDescriptorStep(descriptorResolver, ciParser, scope, this.getXmlDescriptor(), new SingleEnvCheck())});
    }
}

