/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.util;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retrier<T> {
    private Logger log = LoggerFactory.getLogger(Retrier.class);
    private Callable<T> action;

    public Retrier(Callable<T> action) {
        this.action = action;
    }

    public T retryFor(int timeout, int delay) throws TimeoutException {
        int attempts = (int)Math.floor(timeout / delay) + 1;
        int a = 0;
        while (true) {
            try {
                this.log.debug("Performing attempt {}", (Object)(++a));
                return this.action.call();
            }
            catch (Exception e) {
                if (a == attempts) {
                    throw new TimeoutException("Can not retry anymore..." + e.getMessage());
                }
                try {
                    this.log.debug("Sleeping for " + delay + " s...");
                    Thread.sleep(delay * 1000);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e1);
                }
            }
        }
    }
}

