package com.xebialabs.deployit.plugin.cloud.step;

import com.xebialabs.deployit.plugin.api.deployment.planning.DefaultOrders;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.CloudEnvironmentParameters;

@SuppressWarnings("serial")
public class CheckParametersStep implements Step {

    private final CloudEnvironmentParameters parameters;

    public CheckParametersStep(final CloudEnvironmentParameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public int getOrder() {
        return DefaultOrders.PRE_FLIGHT;
    }

    @Override
    public String getDescription() {
        return "Check if given parameters are valid";
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {

        Repository repository = ctx.getRepository();

        if(repository.exists(parameters.getEnvironmentId())){
            ctx.logError("CI with id [" + parameters.getEnvironmentId() + "] already exists. Please provide a non-existing id because the plugin will create it.");
            return StepExitCode.FAIL;
        }
        ctx.logOutput("Provided Environment id is OK.");

        if(!repository.exists(parameters.getHostsPath())){
            ctx.logError("Infrastructure parent with id [" + parameters.getHostsPath() + "] does not exists. Please provide a valid parent or use the Infrastructure root node.");
            return StepExitCode.FAIL;
        } else {
            ConfigurationItem item = repository.read(parameters.getHostsPath());

            if( ! (item.getId().startsWith("Infrastructure") &&
                    (item.getType().instanceOf(Type.valueOf("core.Directory")) ||
                     item.getType().instanceOf(Type.valueOf("internal.Root")))) )
            {
                ctx.logError("Infrastructure parent with id [" + parameters.getHostsPath() + "] is not the Infrastructure root node or a CI of type core.Directory.");
                return StepExitCode.FAIL;
            }
        }
        ctx.logOutput("Provided Infrastructure parent id is OK.");

        return StepExitCode.SUCCESS;
    }

}
