/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.ci;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.ci.CloudEnvironmentParameters;
import com.xebialabs.deployit.plugin.cloud.step.CheckParametersStep;
import com.xebialabs.deployit.plugin.cloud.step.RegisterEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.step.RegisterInstancesStep;
import com.xebialabs.deployit.plugin.cloud.step.ValidateDescriptorStep;
import com.xebialabs.deployit.plugin.cloud.step.plan.SingleStepFilter;
import com.xebialabs.deployit.plugin.cloud.step.plan.StepOrderComparator;
import com.xebialabs.deployit.plugin.cloud.step.rule.SingleEnvCheck;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

@Metadata(description="Cloud environment template", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class EnvironmentTemplate
extends BaseConfigurationItem {
    private static InstanceDescriptorResolver descriptorResolver = new InstanceDescriptorResolver();
    private static CiParser ciParser = new CiParser();
    @Property(required=false, size=Property.Size.LARGE, label="Description of the template")
    private String description;
    @Property(required=true, label="Host templates")
    private List<BaseHostTemplate> hostTemplates;
    @Property(required=true, size=Property.Size.LARGE, label="Environment descriptor", description="Freemarker template of XML which describes environment")
    private String xmlDescriptor;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHostTemplates(List<BaseHostTemplate> hostTemplates) {
        this.hostTemplates = hostTemplates;
    }

    public void setXmlDescriptor(String xmlDescriptor) {
        this.xmlDescriptor = xmlDescriptor;
    }

    public List<BaseHostTemplate> getHostTemplates() {
        return this.hostTemplates;
    }

    public String getXmlDescriptor() {
        return this.xmlDescriptor;
    }

    @ControlTask(label="Instantiate environment", parameterType="cloud.CloudEnvironmentParameters", description="Instantiate environment and all hosts, which templates are linked to this environment template")
    public List<? extends Step> instantiate(CloudEnvironmentParameters parameters) {
        ArrayList steps = Lists.newArrayList();
        steps.add(new CheckParametersStep(parameters));
        HashMap waitStepsAdded = Maps.newHashMap();
        if (!this.getHostTemplates().isEmpty()) {
            int seq = 1;
            for (BaseHostTemplate template : this.getHostTemplates()) {
                Collection presentSteps = (Collection)waitStepsAdded.get(template.getType());
                Collection stepsToAdd = Collections2.filter(template.produceCreateSteps(this.getName(), seq), (Predicate)new SingleStepFilter(presentSteps));
                steps.addAll(stepsToAdd);
                waitStepsAdded.put(template.getType(), presentSteps == null ? stepsToAdd : ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)presentSteps, (Iterable)stepsToAdd)));
                ++seq;
            }
            steps.add(new RegisterInstancesStep(descriptorResolver, ciParser, parameters.getHostsPath()));
        }
        steps.add(new RegisterEnvironmentStep(descriptorResolver, ciParser, this, parameters.getEnvironmentId()));
        Collections.sort(steps, new StepOrderComparator());
        return steps;
    }

    @ControlTask(label="Validate descriptor", description="Validate XML descriptor of the environment template")
    public List<? extends Step> validateEnvironmentDescriptor() {
        HashMap scope = Maps.newHashMap();
        scope.put("environmentId", "Environments/descriptorTestEnv");
        scope.put("hosts", Collections.emptyList());
        scope.put("environmentTemplate", this);
        return Lists.newArrayList((Object[])new ValidateDescriptorStep[]{new ValidateDescriptorStep(descriptorResolver, ciParser, scope, this.getXmlDescriptor(), new SingleEnvCheck())});
    }
}

