package com.xebialabs.deployit.plugin.cloud.step;

import java.util.List;
import com.google.common.base.Function;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.plugin.cloud.ci.Environment;

import static com.google.common.collect.Collections2.transform;

@SuppressWarnings("serial")
public class WipeEnvironmentStep implements Step {

    private Environment environment;

    public WipeEnvironmentStep(final Environment environment) {
        this.environment = environment;
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER + 40;
    }

    @Override
    public String getDescription() {
        return "Remove all deployed applications from the environment " + environment.getId();
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {
        List<ConfigurationItem> apps = ctx.getRepository().search(Type.valueOf(DeployedApplication.class), environment.getId());
        if (!apps.isEmpty()) {
            for (ConfigurationItem app : apps) {
                ctx.logOutput("To be deleted: " + app);
            }

            String[] ids = transform(apps, new Function<ConfigurationItem, String>() {
                @Override
                public String apply(final ConfigurationItem input) {
                    return input.toString();
                }
            }).toArray(new String[apps.size()]);
            ctx.getRepository().delete(ids);
        }
        return StepExitCode.SUCCESS;
    }
}
