/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloud.util;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class CiUtils {
    public static String passwordMask = "********";

    public static ConfigurationItem securePasswords(ConfigurationItem ci) {
        return CiUtils.securePasswords(ci, Collections.EMPTY_LIST);
    }

    private static ConfigurationItem securePasswords(ConfigurationItem ci, List<String> ids) {
        if (ci == null) {
            return null;
        }
        if (ids.contains(ci.getId())) {
            throw new RuntimeException("Circular reference detected in CI tree");
        }
        final ArrayList updatedIds = Lists.newArrayList(ids);
        updatedIds.add(ci.getId());
        Function<ConfigurationItem, Object> secureCollection = new Function<ConfigurationItem, Object>(){

            public Object apply(ConfigurationItem ci) {
                return CiUtils.securePasswords(ci, updatedIds);
            }
        };
        ConfigurationItem ciWithoutPasswords = ci.getType().getDescriptor().newInstance(ci.getId());
        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
            Object newValue;
            switch (pd.getKind()) {
                case CI: {
                    newValue = CiUtils.securePasswords((ConfigurationItem)pd.get(ci), updatedIds);
                    break;
                }
                case SET_OF_CI: {
                    newValue = Sets.newHashSet((Iterable)Collections2.transform((Collection)((Set)pd.get(ci)), (Function)secureCollection));
                    break;
                }
                case LIST_OF_CI: {
                    newValue = Lists.transform((List)((List)pd.get(ci)), (Function)secureCollection);
                    break;
                }
                default: {
                    newValue = pd.isPassword() ? passwordMask : pd.get(ci);
                }
            }
            ciWithoutPasswords.setProperty(pd.getName(), newValue);
        }
        return ciWithoutPasswords;
    }
}

