/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cloudburst;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.HostAccessMethod;
import com.xebialabs.deployit.ci.OperatingSystemFamily;
import com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer;
import com.xebialabs.deployit.task.TaskExecutionContext;
import com.xebialabs.deployit.translation.DiscoveryChangePlan;
import java.util.HashMap;
import java.util.Map;

public class DiscoverWasUnmanagedServerOnVirtualSystemStep
implements Step {
    public static final String WAS_UNMANAGED_SERVER_ON_VIRTUAL_SYSTEM_PREFIX = "virtualsystem.wasunmanagedserver.";
    private String systemName;

    public DiscoverWasUnmanagedServerOnVirtualSystemStep(String systemName) {
        this.systemName = systemName;
    }

    public String getDescription() {
        return "Discover WebSphere Application Server on virtual system " + this.systemName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        WasUnmanagedServer discoveredServer1;
        String hostname = (String)ctx.getAttribute("virtualsystem.hostname." + this.systemName);
        if (hostname == null) {
            throw new IllegalStateException("Cannot find hostname for virtual system " + this.systemName + " in step execution context");
        }
        Host virtualSystemHost = new Host();
        virtualSystemHost.setLabel(hostname);
        virtualSystemHost.setAddress(hostname);
        virtualSystemHost.setUsername("root");
        virtualSystemHost.setPassword("iicu5er");
        virtualSystemHost.setOperatingSystemFamily(OperatingSystemFamily.UNIX);
        virtualSystemHost.setAccessMethod(HostAccessMethod.SSH_SFTP);
        WasUnmanagedServer server1 = new WasUnmanagedServer();
        server1.setHost(virtualSystemHost);
        server1.setLabel(hostname + "/server1");
        server1.setUsername("virtuser");
        server1.setPassword("iicu5er");
        server1.setWasHome("/opt/IBM/WebSphere/Profiles/DefaultAppSrv01");
        server1.setPort(8880);
        DiscoveryChangePlan cp = new DiscoveryChangePlan();
        HashMap info = Maps.newHashMap();
        TaskExecutionContext context = new TaskExecutionContext((Map)info);
        try {
            discoveredServer1 = server1.discover((Map)info, (ChangePlan)cp);
        }
        finally {
            context.destroy();
        }
        ctx.setAttribute(WAS_UNMANAGED_SERVER_ON_VIRTUAL_SYSTEM_PREFIX + this.systemName, (Object)discoveredServer1);
        return true;
    }
}

