/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloudburst;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.StepExecutionContextCallbackHandler;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.hostsession.CommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.hostsession.HostSessionFactory;
import com.xebialabs.deployit.plugin.cloudburst.CloudBurstAppliance;
import java.util.ArrayList;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public abstract class CloudBurstCliStep
implements Step {
    private final String description;
    private final CloudBurstAppliance appliance;
    private final String scriptResource;
    private final String[] args;

    public CloudBurstCliStep(String description, CloudBurstAppliance appliance, String scriptResource, String ... args) {
        this.description = description;
        this.appliance = appliance;
        this.scriptResource = scriptResource;
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(CommandExecutionCallbackHandler handler) {
        HostSession s = HostSessionFactory.getHostSession((Host)this.appliance.getCliHost());
        try {
            HostFile scriptFileOnCliHost = s.copyToTemporaryFile((Resource)new ClassPathResource(this.scriptResource));
            ArrayList<String> cmdline = new ArrayList<String>();
            cmdline.add(this.appliance.getCliHome() + "/bin/cloudburst");
            cmdline.add("-h");
            cmdline.add(this.appliance.getAddress());
            cmdline.add("-u");
            cmdline.add(this.appliance.getUsername());
            cmdline.add("-p");
            cmdline.add(this.appliance.getPassword());
            cmdline.add("-f");
            cmdline.add(scriptFileOnCliHost.getPath());
            for (String each : this.args) {
                cmdline.add(each);
            }
            String[] cmdlineArray = cmdline.toArray(new String[cmdline.size()]);
            int n = s.execute(handler, cmdlineArray);
            return n;
        }
        finally {
            s.close();
        }
    }

    public boolean execute(StepExecutionContext context) {
        int res = this.execute((CommandExecutionCallbackHandler)new StepExecutionContextCallbackHandler(context));
        return res == 0;
    }

    public String getDescription() {
        return this.description;
    }
}

