/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cloudburst;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasUnmanagedServer;
import com.xebialabs.deployit.plugin.was.step.WasDeployApplicationStep;
import com.xebialabs.deployit.plugin.was.step.WasStartApplicationStep;
import java.util.ArrayList;
import java.util.Collection;

public class DeployAndStartEarToDiscoveredWasUnmanagedServerOnVirtualSystemStep
implements Step {
    private Ear ear;
    private String systemName;

    public DeployAndStartEarToDiscoveredWasUnmanagedServerOnVirtualSystemStep(Ear ear, String systemName) {
        this.ear = ear;
        this.systemName = systemName;
    }

    public String getDescription() {
        return "Deploy " + this.ear + " on virtual system " + this.systemName + " and start it";
    }

    public boolean execute(StepExecutionContext ctx) {
        WasUnmanagedServer server1 = (WasUnmanagedServer)ctx.getAttribute("virtualsystem.wasunmanagedserver." + this.systemName);
        if (server1 == null) {
            throw new IllegalStateException("Cannot find discovered WAS server for virtual system " + this.systemName + " in step execution context");
        }
        ArrayList targets = Lists.newArrayList();
        targets.add(server1);
        WasDeployApplicationStep deployStep = new WasDeployApplicationStep((WasCell)server1, this.ear, (Collection)targets, null, "default_host", null, 1, null, null, null, null, null);
        if (!deployStep.execute(ctx)) {
            return false;
        }
        WasStartApplicationStep startStep = new WasStartApplicationStep((WasTarget)server1, this.ear);
        return startStep.execute(ctx);
    }
}

