package com.xebialabs.deployit.plugin.cmd.step;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.cmd.deployed.DeployedCommand;

@SuppressWarnings("serial")
public class NoCommandStep implements DeploymentStep {

    private DeployedCommand command;
	private int order;

	public NoCommandStep(int order, DeployedCommand deployedCommand) {
		this.order = order;
		this.command = deployedCommand;
    }

	@Override
    public String getDescription() {
        return "Undo " + command.getName();
    }

    @Override
    public Result execute(DeploymentExecutionContext ctx) throws Exception {
        ctx.logOutput("Please note the command will be undeployed from Deployit. The target middleware will not be affected. " +
        "Any undeployment changes required on the target middleware should be manually performed.");
        return Result.Success;
    }

	@Override
	public int getOrder() {
		return order;
	}
}
