package com.xebialabs.deployit.plugin.cmd.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.cmd.deployed.DeployedCommand;

@SuppressWarnings("serial")
public class NoCommandStep implements Step {

    private DeployedCommand command;
    private int order;

    public NoCommandStep(int order, DeployedCommand deployedCommand) {
        this.order = order;
        this.command = deployedCommand;
    }

    @Override
    public String getDescription() {
        return "Undo " + command.getName();
    }

    @Override
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        ctx.logOutput("Please note the command will be undeployed from XL Deploy. The target middleware will not be affected. " +
        "Any undeployment changes required on the target middleware should be manually performed.");
        return StepExitCode.SUCCESS;
    }

    @Override
    public int getOrder() {
        return order;
    }
}
