/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cmd.step;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.cmd.deployed.DeployedCommand;
import com.xebialabs.deployit.plugin.overthere.DefaultExecutionOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.satellite.Satellite;
import com.xebialabs.xlplatform.satellite.SatelliteAware;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExecuteCommandStep
implements SatelliteAware {
    private DeployedCommand command;
    private transient OverthereConnection localConn;
    private transient OverthereConnection remoteConn;
    private transient ExecutionContext ctx;
    private Pattern placeHolderPattern = Pattern.compile("\\$\\{(.*)\\}");
    private int order;

    public ExecuteCommandStep(int order, DeployedCommand deployedCommand) {
        this.order = order;
        this.command = deployedCommand;
        this.validateCommandLineDependencyPlaceholders();
    }

    private Iterable<String> getCommandLineArgs() {
        String params = this.command.getCommandLine();
        if (!Strings.nullToEmpty((String)params).trim().isEmpty()) {
            params = params.replace('\n', ' ');
            return Splitter.on((char)' ').split((CharSequence)params);
        }
        return Lists.newArrayList();
    }

    private void validateCommandLineDependencyPlaceholders() {
        for (String arg : this.getCommandLineArgs()) {
            String dependencyRef = this.extractDependencyRefFromPlaceholderArg(arg);
            if (dependencyRef == null) continue;
            boolean found = false;
            for (DeployableArtifact deployableArtifact : this.command.getDependencies()) {
                if (!deployableArtifact.getName().equals(dependencyRef)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Placeholder arg " + arg + " does not refer to a valid dependency");
        }
    }

    private String extractDependencyRefFromPlaceholderArg(String arg) {
        Matcher matcher = this.placeHolderPattern.matcher(arg);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public String getDescription() {
        return "Execute " + this.command.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        try {
            this.ctx = ctx;
            Map<String, OverthereFile> uploadedDependencies = this.uploadDependencies();
            CmdLine cmdLine = this.resolveCommandLine(uploadedDependencies);
            try (DefaultExecutionOutputHandler stdoutHandler = DefaultExecutionOutputHandler.handleStdout((ExecutionContext)ctx);
                 DefaultExecutionOutputHandler stderrHandler = DefaultExecutionOutputHandler.handleStderr((ExecutionContext)ctx);){
                ctx.logOutput("Executing command line : " + cmdLine.toCommandLine(((Host)this.command.getContainer()).getOs(), true));
                int rc = this.getRemoteConnection().execute((OverthereExecutionOutputHandler)stdoutHandler, (OverthereExecutionOutputHandler)stderrHandler, cmdLine);
                if (rc != 0) {
                    ctx.logError("Command failed with return code " + rc);
                    StepExitCode stepExitCode = StepExitCode.FAIL;
                    return stepExitCode;
                }
            }
        }
        finally {
            this.disconnect();
        }
        return StepExitCode.SUCCESS;
    }

    private Map<String, OverthereFile> uploadDependencies() {
        HashMap uploadedFiles = Maps.newHashMap();
        if (this.command.getDependencies() == null || this.command.getDependencies().isEmpty()) {
            return uploadedFiles;
        }
        OverthereFile tempDir = this.getRemoteConnection().getTempFile("exec_cmd", ".tmp");
        tempDir.mkdir();
        this.ctx.logOutput("Uploading " + this.command.getDependencies().size() + " dependent files to " + tempDir.getPath());
        for (DeployableArtifact deployableArtifact : this.command.getDependencies()) {
            String name = deployableArtifact.getName();
            OverthereFile uploadedFile = tempDir.getFile(name);
            OverthereFile localFile = this.getLocalConnection().getFile(deployableArtifact.getFile().getPath());
            localFile.copyTo(uploadedFile);
            this.ctx.logOutput("Uploaded " + name);
            uploadedFiles.put(name, uploadedFile);
        }
        this.ctx.logOutput("Uploading done.");
        return uploadedFiles;
    }

    private CmdLine resolveCommandLine(Map<String, OverthereFile> dependencies) {
        CmdLine cmdLine = new CmdLine();
        for (String arg : this.getCommandLineArgs()) {
            String dependencyRef = this.extractDependencyRefFromPlaceholderArg(arg);
            if (dependencyRef != null) {
                cmdLine.addArgument(dependencies.get(dependencyRef).getPath());
                continue;
            }
            cmdLine.addArgument(arg);
        }
        return cmdLine;
    }

    private OverthereConnection getLocalConnection() {
        if (this.localConn == null) {
            this.localConn = Overthere.getConnection((String)"local", (ConnectionOptions)new ConnectionOptions());
        }
        return this.localConn;
    }

    private OverthereConnection getRemoteConnection() {
        if (this.remoteConn == null) {
            this.remoteConn = ((Host)this.command.getContainer()).getConnection();
        }
        return this.remoteConn;
    }

    private void disconnect() {
        if (this.localConn != null) {
            this.localConn.close();
        }
        if (this.remoteConn != null) {
            this.remoteConn.close();
        }
        this.localConn = null;
        this.remoteConn = null;
    }

    public int getOrder() {
        return this.order;
    }

    public Satellite getSatellite() {
        return ((Host)this.command.getContainer()).getHost().getSatellite();
    }
}

