/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.cmd.deployed;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseDeployed;
import com.xebialabs.deployit.plugin.cmd.ci.Command;
import com.xebialabs.deployit.plugin.cmd.step.ExecuteCommandStep;
import com.xebialabs.deployit.plugin.cmd.step.NoCommandStep;
import com.xebialabs.deployit.plugin.file.File;
import com.xebialabs.deployit.plugin.overthere.Host;
import java.util.ArrayList;
import java.util.Set;

@Metadata(description="Command deployed to a Host")
public class DeployedCommand
extends BaseDeployed<Command, Host> {
    private static final String UNDO_PREFIX = "/undo ";
    @Property(description="Order of the command", defaultValue="50")
    private int order = 50;
    @Property(required=false, description="Artifacts that the command depends on")
    private Set<File> dependencies = Sets.newHashSet();
    @Property(required=true, size=Property.Size.LARGE, description="Command line to execute on host. Dependent artifacts can be referred to using ${artifact name}.")
    private String commandLine;
    @Property(required=false, description="Command to execute when undeploying command", category="Undo")
    private Command undoCommand;
    @Property(required=false, size=Property.Size.LARGE, description="Undo command line to execute on host. Dependent artifacts can be referred to using ${artifact name}.", category="Undo")
    private String undoCommandLine;
    @Property(description="Order of the undo command", defaultValue="49", category="Undo")
    private int undoOrder = 49;
    @Property(required=false, description="Artifacts that the undo command depends on")
    private Set<File> undoDependencies = Sets.newHashSet();
    @Property(required=false, description="Indicates whether the undoCommand should be run on an upgrade", category="Undo")
    private boolean runUndoCommandOnUpgrade = true;
    @Property(required=false, isTransient=true, description="Forces the command to be rerun.")
    private boolean rerunCommand;

    @Create
    public void executeCreateCommand(DeploymentPlanningContext ctx, Delta delta) {
        ctx.addStepWithCheckpoint((Step)new ExecuteCommandStep(this.order, this), delta);
    }

    @Modify
    public void executeModifyCommand(DeploymentPlanningContext ctx, Delta delta) {
        this.setOrOverrideUndoCommand();
        if (this.undoCommand != null && this.runUndoCommandOnUpgrade) {
            DeployedCommand deployedUndoCommand = this.createDeployedUndoCommand();
            ctx.addStepWithCheckpoint((Step)new ExecuteCommandStep(this.undoCommand.getOrder(), deployedUndoCommand), delta, Operation.DESTROY);
        }
        ctx.addStepWithCheckpoint((Step)new ExecuteCommandStep(this.order, this), delta);
    }

    private void setOrOverrideUndoCommand() {
        if (this.hasAttributeBasedUndoCommand()) {
            this.undoCommand = (Command)Type.valueOf(Command.class).getDescriptor().newInstance(((Command)this.getDeployable()).getId());
            this.undoCommand.setCommandLine(this.undoCommandLine);
            this.undoCommand.setDependencies(this.undoDependencies);
            this.undoCommand.setOrder(this.undoOrder);
        }
    }

    private DeployedCommand createDeployedUndoCommand() {
        String id = this.getDeployedCommandId();
        DeployedCommand deployedUndoCommand = (DeployedCommand)Type.valueOf(DeployedCommand.class).getDescriptor().newInstance(id);
        deployedUndoCommand.setDeployable((Deployable)this.undoCommand);
        deployedUndoCommand.setContainer(this.getContainer());
        for (PropertyDescriptor property : this.undoCommand.getType().getDescriptor().getPropertyDescriptors()) {
            if (!deployedUndoCommand.hasProperty(property.getName())) continue;
            deployedUndoCommand.setProperty(property.getName(), this.undoCommand.getProperty(property.getName()));
        }
        return deployedUndoCommand;
    }

    @Destroy
    public void destroyCommand(DeploymentPlanningContext ctx, Delta delta) {
        this.setOrOverrideUndoCommand();
        if (this.undoCommand != null) {
            DeployedCommand deployedUndoCommand = this.createDeployedUndoCommand();
            ctx.addStepWithCheckpoint((Step)new ExecuteCommandStep(this.undoCommand.getOrder(), deployedUndoCommand), delta);
        } else {
            ctx.addStepWithCheckpoint((Step)new NoCommandStep(this.order, this), delta);
        }
    }

    public Set<File> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Set<File> dependencies) {
        this.dependencies = dependencies;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = commandLine;
    }

    public Command getUndoCommand() {
        return this.undoCommand;
    }

    public void setUndoCommand(Command undoCommand) {
        this.undoCommand = undoCommand;
    }

    public boolean isRunUndoCommandOnUpgrade() {
        return this.runUndoCommandOnUpgrade;
    }

    public void setRunUndoCommandOnUpgrade(boolean runUndoCommandOnUpgrade) {
        this.runUndoCommandOnUpgrade = runUndoCommandOnUpgrade;
    }

    public boolean isRerunCommand() {
        return this.rerunCommand;
    }

    public void setRerunCommand(boolean rerunCommand) {
        this.rerunCommand = rerunCommand;
    }

    public String getUndoCommandLine() {
        return this.undoCommandLine;
    }

    public void setUndoCommandLine(String undoCommandLine) {
        this.undoCommandLine = undoCommandLine;
    }

    public int getUndoOrder() {
        return this.undoOrder;
    }

    public void setUndoOrder(int undoOrder) {
        this.undoOrder = undoOrder;
    }

    public Set<File> getUndoDependencies() {
        return this.undoDependencies;
    }

    public void setUndoDependencies(Set<File> undoDependencies) {
        this.undoDependencies = undoDependencies;
    }

    private String getParentId(String id) {
        Object[] nameParts = id.split("/");
        ArrayList list = Lists.newArrayList((Object[])nameParts);
        if (list.size() > 1) {
            list.remove(nameParts.length - 1);
        }
        return Joiner.on((String)"/").join((Iterable)list);
    }

    private boolean hasAttributeBasedUndoCommand() {
        return this.undoCommandLine != null && !this.undoCommandLine.isEmpty();
    }

    private String getDeployedCommandId() {
        if (this.hasAttributeBasedUndoCommand()) {
            return this.getParentId(this.undoCommand.getId()) + UNDO_PREFIX + this.undoCommand.getName();
        }
        return this.undoCommand.getId();
    }
}

