package com.xebialabs.deployit.plugins.releaseauth.step;

import java.util.Set;

import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentExecutionContext;
import com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.plugins.releaseauth.ReleaseCondition;

import static java.lang.String.format;

@SuppressWarnings("serial")
public class LogReleaseConditionsStep implements DeploymentStep {
	private final Set<ReleaseCondition> conditions;
	private Version deploymentPackage;
	private final int order;

    public LogReleaseConditionsStep(int order, Set<ReleaseCondition> conditions, Version deploymentPackage) {
		this.conditions = conditions;
		this.deploymentPackage = deploymentPackage;
		this.order = order;
	}

	@Override
	public Result execute(DeploymentExecutionContext ctx) throws Exception {
        ctx.logOutput(" release conditions:");
        ctx.logOutput(buildValidatedConditionsMessage());
		return Result.Success;
	}

    private String buildValidatedConditionsMessage() {
        StringBuilder message = new StringBuilder();
        for (ReleaseCondition condition : conditions) {
            message.append(format("Condition '%s': OK%n", condition));
        }
        return message.toString();
    }

	@Override
	public String getDescription() {
		return format("Logging release authorization for deployment of '%s'", deploymentPackage);
	}
	
	@Override
	public int getOrder() {
		return order;
	}
}
