/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.releaseauth.command;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.engine.spi.command.CreateCiCommand;
import com.xebialabs.deployit.engine.spi.command.CreateCisCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCiCommand;
import com.xebialabs.deployit.engine.spi.command.UpdateCisCommand;
import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.deployit.engine.spi.event.DeployitEventListener;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Version;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import nl.javadude.t2bus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DeployitEventListener
public class RepositoryCommandListener {
    public static final String ADMIN = "admin";
    public static final String VERIFY_CHECKLIST_PERMISSIONS_ON_CREATE = "verifyChecklistPermissionsOnCreate";
    private static final Logger logger = LoggerFactory.getLogger(RepositoryCommandListener.class);

    @Subscribe(canVeto=true)
    public void checkWhetherCreateIsAllowed(CreateCiCommand command) {
        if (this.checkCisNessessary(Lists.newArrayList((Object[])new ConfigurationItem[]{command.getCi()}))) {
            RepositoryCommandListener.checkCis(command.getCi(), RepositoryCommandListener.getSatisfactionProperties(this.getPropertyDescriptors(command.getCi())), Sets.newHashSet((Iterable)command.getRoles()), command.getUsername());
        }
    }

    @Subscribe(canVeto=true)
    public void checkWhetherCreateIsAllowed(CreateCisCommand command) {
        if (this.checkCisNessessary(command.getCis())) {
            for (ConfigurationItem ci : command.getCis()) {
                RepositoryCommandListener.checkCis(ci, RepositoryCommandListener.getSatisfactionProperties(this.getPropertyDescriptors(ci)), Sets.newHashSet((Iterable)command.getRoles()), command.getUsername());
            }
        }
    }

    @Subscribe(canVeto=true)
    public void checkWhetherUpdateIsAllowed(UpdateCiCommand command) {
        RepositoryCommandListener.checkCis(command.getUpdate().getNewCi(), RepositoryCommandListener.getChangedProperties(command.getUpdate(), RepositoryCommandListener.getSatisfactionProperties(this.getPropertyDescriptors(command.getUpdate().getNewCi()))), Sets.newHashSet((Iterable)command.getRoles()), command.getUsername());
    }

    @Subscribe(canVeto=true)
    public void checkWhetherUpdateIsAllowed(UpdateCisCommand command) {
        for (Update update : command.getUpdates()) {
            RepositoryCommandListener.checkCis(update.getNewCi(), RepositoryCommandListener.getChangedProperties(update, RepositoryCommandListener.getSatisfactionProperties(this.getPropertyDescriptors(update.getNewCi()))), Sets.newHashSet((Iterable)command.getRoles()), command.getUsername());
        }
    }

    private static void checkCis(ConfigurationItem newCi, FluentIterable<PropertyDescriptor> changed, Set<String> roles, String username) {
        FluentIterable<PropertyDescriptor> propertiesWithRolesLimitations;
        if (!newCi.getType().isSubTypeOf(Type.valueOf(Version.class))) {
            return;
        }
        Descriptor descriptor = newCi.getType().getDescriptor();
        FluentIterable<PropertyDescriptor> noPermission = RepositoryCommandListener.getNoPermission(newCi, roles, username, descriptor, propertiesWithRolesLimitations = RepositoryCommandListener.getPropertiesWithRolesLimitations(newCi, changed));
        if (!noPermission.isEmpty()) {
            logger.error("User [{}] tried to update release conditions {} but didn't have permission for {} on ci {}", new Object[]{username, changed, noPermission, newCi.getId()});
            throw new CannotSetReleaseConditionsException((List)RepositoryCommandListener.getPropertyNames(noPermission), newCi);
        }
        if (!changed.isEmpty()) {
            logger.info("User [{}] has updated release conditions {} on ci {}", new Object[]{username, changed, newCi.getId()});
        }
    }

    private static ImmutableList<String> getPropertyNames(FluentIterable<PropertyDescriptor> satisfiesForWhichUserHasNoPermission) {
        return satisfiesForWhichUserHasNoPermission.transform((Function)new Function<PropertyDescriptor, String>(){

            public String apply(PropertyDescriptor propertyDescriptor) {
                return propertyDescriptor.getName();
            }
        }).toList();
    }

    private static FluentIterable<PropertyDescriptor> getNoPermission(final ConfigurationItem ci, final Set<String> roles, final String username, final Descriptor descriptor, FluentIterable<PropertyDescriptor> properties) {
        return properties.filter((Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor propertyDescriptor) {
                PropertyDescriptor roleProperty = descriptor.getPropertyDescriptor(RepositoryCommandListener.getRolePropertyName(propertyDescriptor));
                Set requiredRoles = (Set)roleProperty.get(ci);
                return !username.equals(RepositoryCommandListener.ADMIN) && Sets.intersection((Set)roles, (Set)Sets.newHashSet((Iterable)requiredRoles)).isEmpty();
            }
        });
    }

    private static FluentIterable<PropertyDescriptor> getPropertiesWithRolesLimitations(final ConfigurationItem ci, FluentIterable<PropertyDescriptor> properties) {
        return properties.filter((Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor propertyDescriptor) {
                return ci.hasProperty(RepositoryCommandListener.getRolePropertyName(propertyDescriptor));
            }
        });
    }

    private static FluentIterable<PropertyDescriptor> getChangedProperties(final Update update, FluentIterable<PropertyDescriptor> properties) {
        return properties.filter((Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return !input.areEqual(update.getPreviousCi(), update.getNewCi());
            }
        });
    }

    private static FluentIterable<PropertyDescriptor> getSatisfactionProperties(Collection<PropertyDescriptor> properties) {
        return FluentIterable.from(properties).filter((Predicate)new Predicate<PropertyDescriptor>(){

            public boolean apply(PropertyDescriptor input) {
                return input.getName().startsWith("satisfies");
            }
        });
    }

    private static String getRolePropertyName(PropertyDescriptor property) {
        String propName = property.getName().substring("satisfies".length());
        return "roles" + propName;
    }

    private Collection<PropertyDescriptor> getPropertyDescriptors(ConfigurationItem ci) {
        Descriptor descriptor = ci.getType().getDescriptor();
        return descriptor.getPropertyDescriptors();
    }

    private boolean checkCisNessessary(List<ConfigurationItem> cis) {
        Application application;
        Version version = (Version)Iterables.find(cis, (Predicate)new Predicate<ConfigurationItem>(){

            public boolean apply(ConfigurationItem input) {
                return input.getType().instanceOf(Type.valueOf(Version.class));
            }
        }, null);
        if (version != null && (application = version.getApplication()) != null && application.hasProperty(VERIFY_CHECKLIST_PERMISSIONS_ON_CREATE)) {
            return (Boolean)application.getProperty(VERIFY_CHECKLIST_PERMISSIONS_ON_CREATE);
        }
        return false;
    }

    @HttpResponseCodeResult(statusCode=403)
    public static class CannotSetReleaseConditionsException
    extends DeployitException {
        private CannotSetReleaseConditionsException(List<String> properties, ConfigurationItem ci) {
            super("You are not authorized to set release conditions %s on %s", new Object[]{properties, ci});
        }
    }
}

