/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.domain.ComputeMetadataBuilder;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.HardwareImpl;
import org.jclouds.compute.predicates.ImagePredicates;
import org.jclouds.domain.Location;

public class HardwareBuilder
extends ComputeMetadataBuilder {
    protected List<Processor> processors = Lists.newArrayList();
    protected int ram;
    protected List<Volume> volumes = Lists.newArrayList();
    protected Predicate<Image> supportsImage = ImagePredicates.any();
    protected String hypervisor;

    public HardwareBuilder() {
        super(ComputeType.HARDWARE);
    }

    public HardwareBuilder processor(Processor processor) {
        this.processors.add(Preconditions.checkNotNull(processor, "processor"));
        return this;
    }

    public HardwareBuilder processors(Iterable<Processor> processors) {
        this.processors = ImmutableList.copyOf(Preconditions.checkNotNull(processors, "processors"));
        return this;
    }

    public HardwareBuilder ram(int ram) {
        this.ram = ram;
        return this;
    }

    public HardwareBuilder volume(Volume volume) {
        this.volumes.add(Preconditions.checkNotNull(volume, "volume"));
        return this;
    }

    public HardwareBuilder volumes(Iterable<Volume> volumes) {
        this.volumes = ImmutableList.copyOf(Preconditions.checkNotNull(volumes, "volumes"));
        return this;
    }

    public HardwareBuilder supportsImage(Predicate<Image> supportsImage) {
        this.supportsImage = Preconditions.checkNotNull(supportsImage, "supportsImage");
        return this;
    }

    public HardwareBuilder hypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
        return this;
    }

    public HardwareBuilder is64Bit(boolean is64Bit) {
        this.supportsImage(is64Bit ? ImagePredicates.is64Bit() : Predicates.not(ImagePredicates.is64Bit()));
        return this;
    }

    @Override
    public HardwareBuilder id(String id) {
        return (HardwareBuilder)HardwareBuilder.class.cast(super.id(id));
    }

    @Override
    public HardwareBuilder tags(Iterable<String> tags) {
        return (HardwareBuilder)HardwareBuilder.class.cast(super.tags(tags));
    }

    @Override
    public HardwareBuilder ids(String id) {
        return (HardwareBuilder)HardwareBuilder.class.cast(super.ids(id));
    }

    @Override
    public HardwareBuilder providerId(String providerId) {
        return (HardwareBuilder)HardwareBuilder.class.cast(super.providerId(providerId));
    }

    @Override
    public HardwareBuilder name(String name) {
        return (HardwareBuilder)HardwareBuilder.class.cast(super.name(name));
    }

    @Override
    public HardwareBuilder location(Location location) {
        return (HardwareBuilder)HardwareBuilder.class.cast(super.location(location));
    }

    @Override
    public HardwareBuilder uri(URI uri) {
        return (HardwareBuilder)HardwareBuilder.class.cast(super.uri(uri));
    }

    @Override
    public HardwareBuilder userMetadata(Map<String, String> userMetadata) {
        return (HardwareBuilder)HardwareBuilder.class.cast(super.userMetadata((Map)userMetadata));
    }

    @Override
    public Hardware build() {
        return new HardwareImpl(this.providerId, this.name, this.id, this.location, this.uri, this.userMetadata, this.tags, this.processors, this.ram, this.volumes, this.supportsImage, this.hypervisor);
    }

    public static HardwareBuilder fromHardware(Hardware in) {
        return ((HardwareBuilder)((HardwareBuilder)new HardwareBuilder().id(in.getId()).providerId(in.getProviderId()).location(in.getLocation()).name(in.getName()).uri(in.getUri()).userMetadata((Map)in.getUserMetadata())).tags(in.getTags())).processors((Iterable)List.class.cast(in.getProcessors())).ram(in.getRam()).volumes((Iterable)List.class.cast(in.getVolumes())).supportsImage(in.supportsImage()).hypervisor(in.getHypervisor());
    }
}

