/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.config;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import org.jclouds.rest.RestApiMetadata;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.internal.BaseRestApiMetadata;
import org.jclouds.rest.internal.RestContextImpl;

public class BindRestContextWithWildcardExtendsExplicitAndRawType
extends AbstractModule {
    private final RestApiMetadata restApiMetadata;

    public BindRestContextWithWildcardExtendsExplicitAndRawType(RestApiMetadata restApiMetadata) throws IllegalArgumentException {
        this.restApiMetadata = Preconditions.checkNotNull(restApiMetadata, "restApiMetadata");
        Preconditions.checkArgument(restApiMetadata.getContext().getRawType().equals(RestContext.class), "this does not work as %s raw type is not RestContext", restApiMetadata.getContext());
    }

    @Override
    protected void configure() {
        TypeToken<RestContext<?, ?>> concreteType = BaseRestApiMetadata.contextToken(TypeToken.of(this.restApiMetadata.getApi()), TypeToken.of(this.restApiMetadata.getAsyncApi()));
        this.bind(TypeLiteral.get(concreteType.getType())).to(TypeLiteral.get(Types.newParameterizedType(RestContextImpl.class, new Type[]{this.restApiMetadata.getApi(), this.restApiMetadata.getAsyncApi()})));
        if (!concreteType.equals(this.restApiMetadata.getContext())) {
            this.bind(TypeLiteral.get(this.restApiMetadata.getContext().getType())).to(TypeLiteral.get(Types.newParameterizedType(RestContextImpl.class, new Type[]{this.restApiMetadata.getApi(), this.restApiMetadata.getAsyncApi()})));
        }
        this.bind(TypeLiteral.get(RestContext.class)).to(TypeLiteral.get(Types.newParameterizedType(RestContextImpl.class, new Type[]{this.restApiMetadata.getApi(), this.restApiMetadata.getAsyncApi()})));
    }
}

