/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http;

import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;

public class HttpCommandRendezvous<T, R extends HttpRequest> {
    private final HttpCommand command;
    private final SynchronousQueue rendezvous;
    private final Future<T> future;

    public HttpCommandRendezvous(HttpCommand command, SynchronousQueue rendezvous, Future<T> future) {
        this.command = command;
        this.rendezvous = rendezvous;
        this.future = future;
    }

    public void setResponse(HttpResponse response) throws InterruptedException {
        this.rendezvous.put(response);
    }

    public void setException(Exception exception) throws InterruptedException {
        this.rendezvous.put(exception);
    }

    public void cancel() {
        this.getFuture().cancel(true);
    }

    public HttpCommand getCommand() {
        return this.command;
    }

    public Future<T> getFuture() {
        return this.future;
    }
}

