/*
 * Decompiled with CFR 0.152.
 */
package org.nnsoft.guice.rocoto.converters;

import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.nnsoft.guice.rocoto.converters.AbstractConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DateConverter
extends AbstractConverter<Date> {
    private final List<String> patterns = new ArrayList<String>();
    private Locale locale;
    private TimeZone timeZone;

    public DateConverter() {
        this.addPattern("yyyy");
        this.addPattern("yyyy-MM");
        this.addPattern("yyyy-MM-dd");
        this.addPattern("yyyy-MM-dd'T'hh:mmZ");
        this.addPattern("yyyy-MM-dd'T'hh:mm:ssZ");
        this.addPattern("yyyy-MM-dd'T'hh:mm:ss.sZ");
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void addPattern(String pattern) {
        this.patterns.add(pattern);
    }

    @Override
    public Object convert(String value, TypeLiteral<?> toType) {
        Exception firstEx = null;
        for (String pattern : this.patterns) {
            try {
                SimpleDateFormat format = this.locale != null ? new SimpleDateFormat(pattern, this.locale) : new SimpleDateFormat(pattern);
                if (this.timeZone != null) {
                    format.setTimeZone(this.timeZone);
                }
                format.setLenient(false);
                Date date = this.parse(value, format);
                if (Calendar.class == toType.getType()) {
                    Calendar calendar = null;
                    calendar = this.locale == null && this.timeZone == null ? Calendar.getInstance() : (this.locale == null ? Calendar.getInstance(this.timeZone) : (this.timeZone == null ? Calendar.getInstance(this.locale) : Calendar.getInstance(this.timeZone, this.locale)));
                    calendar.setTime(date);
                    calendar.setLenient(false);
                    return calendar;
                }
                return date;
            }
            catch (Exception ex) {
                if (firstEx != null) continue;
                firstEx = ex;
            }
        }
        throw new IllegalArgumentException("Error converting '" + value + "' using  patterns " + this.patterns, firstEx);
    }

    private Date parse(String value, DateFormat format) {
        ParsePosition pos = new ParsePosition(0);
        Date parsedDate = format.parse(value, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != value.length() || parsedDate == null) {
            String msg = "Error converting '" + value + "'";
            if (format instanceof SimpleDateFormat) {
                msg = msg + " using pattern '" + ((SimpleDateFormat)format).toPattern() + "'";
            }
            throw new ProvisionException(msg);
        }
        return parsedDate;
    }
}

