/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;
import org.jclouds.xml.XMLParser;

@Singleton
public class ParseXMLWithJAXB<T>
implements Function<HttpResponse, T> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected XMLParser xml;
    protected final TypeLiteral<T> type;

    @Inject
    public ParseXMLWithJAXB(XMLParser xml, TypeLiteral<T> type) {
        this.xml = xml;
        this.type = type;
    }

    public T apply(HttpResponse from) {
        InputStream xml = from.getPayload().getInput();
        try {
            T t = this.apply(xml);
            return t;
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder();
            message.append("Error parsing input");
            this.logger.error(e, message.toString(), new Object[0]);
            throw new HttpResponseException(message.toString() + "\n" + from, null, from, (Throwable)e);
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }

    public T apply(InputStream stream) throws IOException {
        return (T)this.apply(stream, this.type.getRawType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V apply(InputStream stream, Class<V> type) throws IOException {
        try {
            V v = this.xml.fromXML(Strings2.toStringAndClose(stream), type);
            return v;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

