package com.xebialabs.deployit.plugin.ec2.steps;

import org.jclouds.compute.ComputeService;
import org.jclouds.domain.Location;
import org.jclouds.rest.AuthorizationException;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.ec2.ci.Credentials;
import com.xebialabs.deployit.plugin.ec2.util.ServiceFactory;

@SuppressWarnings("serial")
public class ValidateCredentialsStep implements Step {

    private Credentials credentials;

    private ServiceFactory serviceFactory;

    public ValidateCredentialsStep(final Credentials credentials, final ServiceFactory serviceFactory) {
        this.credentials = credentials;
        this.serviceFactory = serviceFactory;
    }

    @Override
    public int getOrder() {
        return DEFAULT_ORDER;
    }

    @Override
    public String getDescription() {
        return "Validating credentials " + credentials.getId() ;
    }

    @Override
    public StepExitCode execute(final ExecutionContext ctx) throws Exception {

        try {
            ctx.logOutput("Connecting to EC2...");
            ComputeService computeService = serviceFactory.getComputeService(credentials.getKey(), credentials.getSecret());

            for (Location location : computeService.listAssignableLocations()) {
                ctx.logOutput("Found available location: " + location.getId() + " :" + location.getDescription());
            }

            ctx.logOutput("Connection succeeded.");

        } catch (AuthorizationException e) {
            ctx.logError("Can not authenticate with provided credentials", e);
            return StepExitCode.FAIL;
        }

        return StepExitCode.SUCCESS;
    }
}
