/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.InterpretableStatement;

public class UnzipHttpResponseIntoDirectory
extends InterpretableStatement {
    public UnzipHttpResponseIntoDirectory(String method, URI endpoint, Multimap<String, String> headers, String dir) {
        super(String.format("({md} %s &&{cd} %s &&curl -X %s -s --retry 20 %s %s >extract.zip && unzip -o -qq extract.zip&& rm extract.zip)\n", dir, dir, method, Joiner.on((char)' ').join(Iterables.transform((Iterable)headers.entries(), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> from) {
                return String.format("-H \"%s: %s\"", from.getKey(), from.getValue());
            }
        })), endpoint.toASCIIString()));
    }
}

