/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.reflect.TypeToken;
import com.google.inject.Module;
import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.Context;
import org.jclouds.View;
import org.jclouds.javax.annotation.Nullable;

@Beta
public interface ApiMetadata
extends Serializable {
    public Builder toBuilder();

    public String getId();

    public String getName();

    public String getEndpointName();

    public String getIdentityName();

    public Optional<String> getCredentialName();

    public String getVersion();

    public Optional<String> getBuildVersion();

    public Optional<String> getDefaultEndpoint();

    public Optional<String> getDefaultIdentity();

    public Optional<String> getDefaultCredential();

    public Properties getDefaultProperties();

    public Set<Class<? extends Module>> getDefaultModules();

    public URI getDocumentation();

    public TypeToken<? extends Context> getContext();

    public Set<TypeToken<? extends View>> getViews();

    public static interface Builder {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder context(TypeToken<? extends Context> var1);

        public Builder view(Class<? extends View> var1);

        public Builder view(TypeToken<? extends View> var1);

        public Builder views(Set<TypeToken<? extends View>> var1);

        public Builder endpointName(String var1);

        public Builder identityName(String var1);

        public Builder credentialName(@Nullable String var1);

        public Builder version(String var1);

        public Builder buildVersion(@Nullable String var1);

        public Builder defaultEndpoint(@Nullable String var1);

        public Builder defaultIdentity(@Nullable String var1);

        public Builder defaultCredential(@Nullable String var1);

        public Builder defaultProperties(Properties var1);

        public Builder defaultModule(Class<? extends Module> var1);

        public Builder defaultModules(Set<Class<? extends Module>> var1);

        public Builder documentation(URI var1);

        public ApiMetadata build();

        public Builder fromApiMetadata(ApiMetadata var1);
    }
}

